/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public final class SpringSecurityOAuth2BindingsPropertiesProcessor
implements BindingsPropertiesProcessor,
ApplicationListener<ApplicationPreparedEvent> {
    public static final String TYPE = "oauth2";
    private static final DeferredLog LOG = new DeferredLog();

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            String provider = binding.getProvider();
            if (provider == null) {
                LOG.warn((Object)String.format("Binding '%s' is missing required 'provider' and will not be processed.", binding.getName()));
                return;
            }
            String clientName = binding.getName();
            properties.put(String.format("spring.security.oauth2.client.registration.%s.provider", clientName), provider);
            map.from("client-id").to(String.format("spring.security.oauth2.client.registration.%s.client-id", clientName));
            map.from("client-secret").to(String.format("spring.security.oauth2.client.registration.%s.client-secret", clientName));
            map.from("client-authentication-method").to(String.format("spring.security.oauth2.client.registration.%s.client-authentication-method", clientName));
            map.from("authorization-grant-type").to(String.format("spring.security.oauth2.client.registration.%s.authorization-grant-type", clientName));
            map.from("authorization-grant-types").when(SpringSecurityOAuth2BindingsPropertiesProcessor::hasSingleValue).toIfAbsent(String.format("spring.security.oauth2.client.registration.%s.authorization-grant-type", clientName));
            map.from("redirect-uri").to(String.format("spring.security.oauth2.client.registration.%s.redirect-uri", clientName));
            map.from("redirect-uris").when(SpringSecurityOAuth2BindingsPropertiesProcessor::hasSingleValue).toIfAbsent(String.format("spring.security.oauth2.client.registration.%s.redirect-uri", clientName));
            map.from("scope").to(String.format("spring.security.oauth2.client.registration.%s.scope", clientName));
            map.from("client-name").to(String.format("spring.security.oauth2.client.registration.%s.client-name", clientName));
            map.from("issuer-uri").to(String.format("spring.security.oauth2.client.provider.%s.issuer-uri", provider));
            map.from("authorization-uri").to(String.format("spring.security.oauth2.client.provider.%s.authorization-uri", provider));
            map.from("token-uri").to(String.format("spring.security.oauth2.client.provider.%s.token-uri", provider));
            map.from("user-info-uri").to(String.format("spring.security.oauth2.client.provider.%s.user-info-uri", provider));
            map.from("user-info-authentication-method").to(String.format("spring.security.oauth2.client.provider.%s.user-info-authentication-method", provider));
            map.from("jwk-set-uri").to(String.format("spring.security.oauth2.client.provider.%s.jwk-set-uri", provider));
            map.from("user-name-attribute").to(String.format("spring.security.oauth2.client.provider.%s.user-name-attribute", provider));
        });
    }

    private static boolean hasSingleValue(@Nullable Object value) {
        return Optional.ofNullable(value).filter(String.class::isInstance).map(String.class::cast).map(s -> s.split(",")).filter(r -> ((String[])r).length == 1).isPresent();
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        LOG.replayTo(this.getClass());
    }
}

