/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class RedisBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "redis";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("client-name").to("spring.data.redis.client-name");
            map.from("cluster.max-redirects").to("spring.data.redis.cluster.max-redirects");
            map.from("cluster.nodes").to("spring.data.redis.cluster.nodes");
            map.from("database").to("spring.data.redis.database");
            map.from("host").to("spring.data.redis.host");
            map.from("password").to("spring.data.redis.password");
            map.from("port").to("spring.data.redis.port");
            map.from("sentinel.master").to("spring.data.redis.sentinel.master");
            map.from("sentinel.nodes").to("spring.data.redis.sentinel.nodes");
            map.from("ssl").to("spring.data.redis.ssl");
            map.from("url").to("spring.data.redis.url");
        });
    }
}

