/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.PropertySourceContributor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;

public final class BindingSpecificEnvironmentPostProcessor
implements ApplicationListener<ApplicationPreparedEvent>,
EnvironmentPostProcessor,
Ordered {
    public static final String BINDING_SPECIFIC_PROPERTY_SOURCE_NAME = "kubernetesServiceBindingSpecific";
    private static final DeferredLog LOG = new DeferredLog();
    final List<BindingsPropertiesProcessor> processors;
    private final Bindings bindings;

    public BindingSpecificEnvironmentPostProcessor() {
        this.bindings = new Bindings();
        this.processors = SpringFactoriesLoader.loadFactories(BindingsPropertiesProcessor.class, (ClassLoader)this.getClass().getClassLoader());
    }

    BindingSpecificEnvironmentPostProcessor(Bindings bindings, BindingsPropertiesProcessor ... processors) {
        this.bindings = bindings;
        this.processors = Arrays.asList(processors);
    }

    public int getOrder() {
        return -2147483639;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        LOG.replayTo(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!Guards.isGlobalEnabled((Environment)environment)) {
            return;
        }
        if (this.bindings.getBindings().isEmpty()) {
            LOG.debug((Object)"No Kubernetes Service Bindings found. Skipping Environment post-processing.");
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.processors.forEach(processor -> processor.process((Environment)environment, this.bindings, properties));
        if (properties.isEmpty()) {
            LOG.debug((Object)"No properties set from Kubernetes Service Bindings. Skipping PropertySource creation.");
            return;
        }
        LOG.info((Object)"Creating binding-specific PropertySource from Kubernetes Service Bindings");
        PropertySourceContributor.contributePropertySource(BINDING_SPECIFIC_PROPERTY_SOURCE_NAME, properties, environment);
    }
}

