/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.bindings.Binding;
import org.springframework.lang.Nullable;

public final class Bindings {
    public static final String CNB_BINDINGS = "CNB_BINDINGS";
    public static final String SERVICE_BINDING_ROOT = "SERVICE_BINDING_ROOT";
    private final List<Binding> bindings;

    public Bindings() {
        this(Bindings.getBindingRoot());
    }

    public Bindings(@Nullable String path) {
        if (path == null) {
            this.bindings = Collections.emptyList();
            return;
        }
        Path p = Paths.get(path, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            this.bindings = Collections.emptyList();
            return;
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s is not a directory", p));
        }
        try {
            this.bindings = Files.list(p).map(Binding::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("unable to list children of '%s'", path), e);
        }
    }

    public Bindings(Binding ... bindings) {
        this.bindings = Arrays.asList(bindings);
    }

    private static String getBindingRoot() {
        Map<String, String> environment = System.getenv();
        if (environment.containsKey(CNB_BINDINGS)) {
            return environment.get(CNB_BINDINGS);
        }
        return System.getenv(SERVICE_BINDING_ROOT);
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Nullable
    public Binding findBinding(String name) {
        return this.bindings.stream().filter(binding -> binding.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<Binding> filterBindings(@Nullable String type) {
        return this.filterBindings(type, null);
    }

    public List<Binding> filterBindings(@Nullable String type, @Nullable String provider) {
        return this.bindings.stream().filter(b -> type == null || b.getType().equalsIgnoreCase(type)).filter(b -> provider == null || b.getProvider() != null && b.getProvider().equalsIgnoreCase(provider)).collect(Collectors.toList());
    }
}

