/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot.pem;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.springframework.cloud.bindings.boot.pem.PemCertificateParser;
import org.springframework.cloud.bindings.boot.pem.PemContent;
import org.springframework.cloud.bindings.boot.pem.PemPrivateKeyParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PemSslStoreHelper {
    private static final String DEFAULT_KEY_ALIAS = "ssl";

    public static KeyStore createKeyStore(String name, String storeType, String certificate, String privateKey, String keyAlias) {
        try {
            Assert.notNull((Object)certificate, (String)"CertificateContent must not be null");
            String type = StringUtils.hasText((String)storeType) ? storeType : KeyStore.getDefaultType();
            KeyStore store = KeyStore.getInstance(type);
            store.load(null);
            String certificateContent = PemContent.load(certificate);
            String privateKeyContent = PemContent.load(privateKey);
            X509Certificate[] certificates = PemCertificateParser.parse(certificateContent);
            PrivateKey pk = PemPrivateKeyParser.parse(privateKeyContent);
            PemSslStoreHelper.addCertificates(store, certificates, pk, keyAlias);
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Unable to create %s store: %s", name, ex.getMessage()), ex);
        }
    }

    private static void addCertificates(KeyStore keyStore, X509Certificate[] certificates, PrivateKey privateKey, String keyAlias) throws KeyStoreException {
        String alias;
        String string = alias = keyAlias != null ? keyAlias : DEFAULT_KEY_ALIAS;
        if (privateKey != null) {
            keyStore.setKeyEntry(alias, privateKey, null, certificates);
        } else {
            for (int index = 0; index < certificates.length; ++index) {
                keyStore.setCertificateEntry(alias + "-" + index, certificates[index]);
            }
        }
    }
}

