/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.aws.secretsmanager.AwsSecretsManagerProperties;
import org.springframework.cloud.aws.secretsmanager.AwsSecretsManagerPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ReflectionUtils;

public class AwsSecretsManagerPropertySourceLocator
implements PropertySourceLocator {
    private String propertySourceName;
    private AWSSecretsManager smClient;
    private AwsSecretsManagerProperties properties;
    private final Set<String> contexts = new LinkedHashSet<String>();
    private Log logger = LogFactory.getLog(this.getClass());

    public AwsSecretsManagerPropertySourceLocator(String propertySourceName, AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        this.propertySourceName = propertySourceName;
        this.smClient = smClient;
        this.properties = properties;
    }

    public AwsSecretsManagerPropertySourceLocator(AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        this("aws-secrets-manager", smClient, properties);
    }

    public List<String> getContexts() {
        return new ArrayList<String>(this.contexts);
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        String appName = this.properties.getName();
        if (appName == null) {
            appName = env.getProperty("spring.application.name");
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        String prefix = this.properties.getPrefix();
        String appContext = prefix + "/" + appName;
        this.addProfiles(this.contexts, appContext, profiles);
        this.contexts.add(appContext);
        String defaultContext = prefix + "/" + this.properties.getDefaultContext();
        this.addProfiles(this.contexts, defaultContext, profiles);
        this.contexts.add(defaultContext);
        CompositePropertySource composite = new CompositePropertySource(this.propertySourceName);
        for (String propertySourceContext : this.contexts) {
            try {
                composite.addPropertySource((PropertySource)this.create(propertySourceContext));
            }
            catch (Exception e) {
                if (this.properties.isFailFast()) {
                    this.logger.error((Object)("Fail fast is set and there was an error reading configuration from AWS Secrets Manager:\n" + e.getMessage()));
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    continue;
                }
                this.logger.warn((Object)("Unable to load AWS secret from " + propertySourceContext), (Throwable)e);
            }
        }
        return composite;
    }

    private AwsSecretsManagerPropertySource create(String context) {
        AwsSecretsManagerPropertySource propertySource = new AwsSecretsManagerPropertySource(context, this.smClient);
        propertySource.init();
        return propertySource;
    }

    private void addProfiles(Set<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }
}

