/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support.destination;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.Topic;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.core.naming.AmazonResourceName;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.StringUtils;

public class DynamicTopicDestinationResolver
implements DestinationResolver<String> {
    private final AmazonSNS amazonSns;
    private final ResourceIdResolver resourceIdResolver;
    private boolean autoCreate;

    public DynamicTopicDestinationResolver(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver) {
        this.amazonSns = amazonSns;
        this.resourceIdResolver = resourceIdResolver;
    }

    public DynamicTopicDestinationResolver(AmazonSNS amazonSns) {
        this(amazonSns, null);
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public String resolveDestination(String name) throws DestinationResolutionException {
        if (this.autoCreate) {
            return this.amazonSns.createTopic(new CreateTopicRequest(name)).getTopicArn();
        }
        String physicalTopicName = name;
        if (this.resourceIdResolver != null) {
            physicalTopicName = this.resourceIdResolver.resolveToPhysicalResourceId(name);
        }
        if (physicalTopicName != null && AmazonResourceName.isValidAmazonResourceName((String)physicalTopicName)) {
            return physicalTopicName;
        }
        String topicArn = this.getTopicResourceName(null, physicalTopicName);
        if (topicArn == null) {
            throw new IllegalArgumentException("No Topic with name: '" + name + "' found. Please use the right topic name or enable auto creation of topics for this DestinationResolver");
        }
        return topicArn;
    }

    private String getTopicResourceName(String marker, String topicName) {
        ListTopicsResult listTopicsResult = this.amazonSns.listTopics(new ListTopicsRequest(marker));
        for (Topic topic : listTopicsResult.getTopics()) {
            AmazonResourceName resourceName = AmazonResourceName.fromString((String)topic.getTopicArn());
            if (!resourceName.getResourceType().equals(topicName)) continue;
            return topic.getTopicArn();
        }
        if (StringUtils.hasText((String)listTopicsResult.getNextToken())) {
            return this.getTopicResourceName(listTopicsResult.getNextToken(), topicName);
        }
        throw new IllegalArgumentException("No topic found for name :'" + topicName + "'");
    }
}

