/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.core.config.xml.XmlWebserviceConfigurationUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class BufferedSqsClientBeanDefinitionUtils {
    public static final String SQS_CLIENT_CLASS_NAME = "com.amazonaws.services.sqs.AmazonSQSAsyncClient";
    static final String BUFFERED_SQS_CLIENT_CLASS_NAME = "com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient";

    private BufferedSqsClientBeanDefinitionUtils() {
    }

    static String getCustomAmazonSqsClientOrDecoratedDefaultSqsClientBeanName(Element element, ParserContext parserContext) {
        BeanDefinition clientBeanDefinition;
        String amazonSqsClientBeanName = XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-sqs", (String)SQS_CLIENT_CLASS_NAME);
        if (!StringUtils.hasText((String)element.getAttribute("amazon-sqs")) && !(clientBeanDefinition = parserContext.getRegistry().getBeanDefinition(amazonSqsClientBeanName)).getBeanClassName().equals(BUFFERED_SQS_CLIENT_CLASS_NAME)) {
            BeanDefinitionBuilder bufferedClientBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)BUFFERED_SQS_CLIENT_CLASS_NAME);
            bufferedClientBeanDefinitionBuilder.addConstructorArgValue((Object)clientBeanDefinition);
            parserContext.getRegistry().removeBeanDefinition(amazonSqsClientBeanName);
            parserContext.getRegistry().registerBeanDefinition(amazonSqsClientBeanName, (BeanDefinition)bufferedClientBeanDefinitionBuilder.getBeanDefinition());
        }
        return amazonSqsClientBeanName;
    }
}

