/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support.converter;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class NotificationRequestConverter
implements MessageConverter {
    private final MappingJackson2MessageConverter jsonMapper = new MappingJackson2MessageConverter();

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        Assert.notNull(message, (String)"message must not be null");
        Map jsonAttributes = (Map)this.jsonMapper.fromMessage(message, Map.class);
        if (!jsonAttributes.containsKey("Type")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(jsonAttributes.get("Type"))) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' is not a valid notification", null);
        }
        if (!jsonAttributes.containsKey("Message")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a message", null);
        }
        return new NotificationRequest((String)jsonAttributes.get("Subject"), (String)jsonAttributes.get("Message"));
    }

    public Message<?> toMessage(Object payload, MessageHeaders header) {
        throw new UnsupportedOperationException("This converter only supports reading a SNS notification and not writing them");
    }

    public static class NotificationRequest {
        private final String subject;
        private final String message;

        public NotificationRequest(String subject, String message) {
            this.subject = subject;
            this.message = message;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

