/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.ec2.AmazonEC2;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.context.config.annotation.EnableStackConfiguration;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientFactoryBean;
import org.springframework.cloud.aws.core.env.stack.config.AutoDetectingStackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackResourceRegistryFactoryBean;
import org.springframework.cloud.aws.core.env.stack.config.StaticStackNameProvider;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextDefaultConfigurationRegistrar.class})
public class ContextStackConfiguration
implements ImportAware {
    private AnnotationAttributes annotationAttributes;
    @Autowired(required=false)
    private RegionProvider regionProvider;
    @Autowired(required=false)
    private AWSCredentialsProvider credentialsProvider;
    @Autowired(required=false)
    private AmazonEC2 amazonEc2;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableStackConfiguration.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableStackConfiguration is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean
    public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
        if (StringUtils.hasText((String)this.annotationAttributes.getString("stackName"))) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new StaticStackNameProvider(this.annotationAttributes.getString("stackName")));
        }
        return new StackResourceRegistryFactoryBean(amazonCloudFormation, (StackNameProvider)new AutoDetectingStackNameProvider(amazonCloudFormation, this.amazonEc2));
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudFormation.class)
    public AmazonWebserviceClientFactoryBean<AmazonCloudFormationClient> amazonCloudFormation() {
        return new AmazonWebserviceClientFactoryBean(AmazonCloudFormationClient.class, this.credentialsProvider, this.regionProvider);
    }
}

