/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.cache.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cloud.aws.cache.CacheFactory;
import org.springframework.cloud.aws.cache.config.annotation.ElastiCacheCacheConfigurer;
import org.springframework.cloud.aws.cache.config.annotation.EnableElastiCache;
import org.springframework.cloud.aws.cache.memcached.MemcachedCacheFactory;
import org.springframework.cloud.aws.cache.redis.RedisCacheFactory;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.core.env.stack.ListableStackResourceFactory;
import org.springframework.cloud.aws.core.env.stack.StackResource;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration
@Import(value={ContextDefaultConfigurationRegistrar.class})
public class ElastiCacheCachingConfiguration
implements ImportAware {
    private static final String CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME = "value";
    private static final String DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME = "defaultExpiration";
    private AnnotationAttributes annotationAttributes;
    @Autowired(required=false)
    private RegionProvider regionProvider;
    @Autowired(required=false)
    private AWSCredentialsProvider credentialsProvider;
    @Autowired(required=false)
    private ListableStackResourceFactory stackResourceFactory;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableElastiCache.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableElasticache is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonElastiCache.class)
    public AmazonElastiCache amazonElastiCache() {
        AmazonElastiCacheClient elastiCacheClient = this.credentialsProvider != null ? new AmazonElastiCacheClient(this.credentialsProvider) : new AmazonElastiCacheClient();
        if (this.regionProvider != null) {
            elastiCacheClient.setRegion(this.regionProvider.getRegion());
        }
        return elastiCacheClient;
    }

    @Bean
    public CachingConfigurer cachingConfigurer(AmazonElastiCache amazonElastiCache, ResourceIdResolver resourceIdResolver, List<CacheFactory> cacheFactories) {
        if (this.annotationAttributes != null && this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME).length > 0) {
            return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.getCacheNamesFromCacheClusterConfigs(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)), cacheFactories);
        }
        return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.getConfiguredCachesInStack(), cacheFactories);
    }

    @Bean
    public RedisCacheFactory redisCacheFactory() {
        RedisCacheFactory redisCacheFactory = new RedisCacheFactory();
        redisCacheFactory.setExpiryTimePerCache(this.getExpiryTimePerCacheFromAnnotationConfig(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)));
        redisCacheFactory.setExpiryTime((Integer)this.annotationAttributes.getNumber(DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME));
        return redisCacheFactory;
    }

    @Bean
    public MemcachedCacheFactory memcachedCacheFactory() {
        MemcachedCacheFactory redisCacheFactory = new MemcachedCacheFactory();
        redisCacheFactory.setExpiryTimePerCache(this.getExpiryTimePerCacheFromAnnotationConfig(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)));
        redisCacheFactory.setExpiryTime((Integer)this.annotationAttributes.getNumber(DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME));
        return redisCacheFactory;
    }

    private List<String> getCacheNamesFromCacheClusterConfigs(AnnotationAttributes[] annotationAttributes) {
        ArrayList<String> cacheNames = new ArrayList<String>(annotationAttributes.length);
        for (AnnotationAttributes annotationAttribute : annotationAttributes) {
            cacheNames.add(annotationAttribute.getString("name"));
        }
        return cacheNames;
    }

    private Map<String, Integer> getExpiryTimePerCacheFromAnnotationConfig(AnnotationAttributes[] annotationAttributes) {
        HashMap<String, Integer> expiryTimePerCache = new HashMap<String, Integer>(annotationAttributes.length);
        for (AnnotationAttributes annotationAttribute : annotationAttributes) {
            expiryTimePerCache.put(annotationAttribute.getString("name"), (Integer)annotationAttribute.getNumber("expiration"));
        }
        return expiryTimePerCache;
    }

    private List<String> getConfiguredCachesInStack() {
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.stackResourceFactory != null) {
            for (StackResource stackResource : this.stackResourceFactory.resourcesByType("AWS::ElastiCache::CacheCluster")) {
                cacheNames.add(stackResource.getLogicalId());
            }
        }
        return cacheNames;
    }
}

