/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.recent;

import java.time.Instant;
import org.cloudfoundry.logcache.v1.Envelope;
import org.cloudfoundry.logcache.v1.EnvelopeType;
import org.cloudfoundry.logcache.v1.LogCacheClient;
import org.cloudfoundry.logcache.v1.ReadRequest;
import org.springframework.cloud.appbroker.logging.ApplicationIdsProvider;
import org.springframework.cloud.appbroker.logging.recent.RecentLogsProvider;
import reactor.core.publisher.Flux;

public class ApplicationRecentLogsProvider
implements RecentLogsProvider {
    private final LogCacheClient logCacheClient;
    private final ApplicationIdsProvider applicationIdsProvider;

    public ApplicationRecentLogsProvider(LogCacheClient logCacheClient, ApplicationIdsProvider applicationIdsProvider) {
        this.logCacheClient = logCacheClient;
        this.applicationIdsProvider = applicationIdsProvider;
    }

    @Override
    public Flux<Envelope> getLogs(String serviceInstanceId) {
        return this.applicationIdsProvider.getApplicationIds(serviceInstanceId).flatMap(this::recentLogs);
    }

    protected Flux<Envelope> recentLogs(String applicationId) {
        return this.logCacheClient.read(ReadRequest.builder().sourceId(applicationId).descending(Boolean.valueOf(true)).envelopeTypes(new EnvelopeType[]{EnvelopeType.LOG}).limit(Integer.valueOf(1000)).startTime(Long.valueOf(Instant.MIN.getEpochSecond())).build()).flatMapMany(readResponse -> Flux.fromIterable((Iterable)readResponse.getEnvelopes().getBatch()));
    }
}

