/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.deployer.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public final class ByteSizeUtils {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(?<amount>\\d+)(?<unit>([mg])?)", 2);

    private ByteSizeUtils() {
    }

    public static Integer parseToMebibytes(String text) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        Matcher matcher = SIZE_PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as a byte size. Expected a number with optional 'm' or 'g' suffix", text));
        }
        int size = Integer.parseInt(matcher.group("amount"));
        if ("g".equalsIgnoreCase(matcher.group("unit"))) {
            size = (int)((long)size * 1024L);
        }
        return size;
    }
}

