/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class GetApplicationRequest {
    private final String name;
    private final Map<String, String> properties;

    protected GetApplicationRequest(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public static GetDeployedAppRequestBuilder builder() {
        return new GetDeployedAppRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class GetDeployedAppRequestBuilder {
        private String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        private GetDeployedAppRequestBuilder() {
        }

        public GetDeployedAppRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GetDeployedAppRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public GetApplicationRequest build() {
            return new GetApplicationRequest(this.name, this.properties);
        }
    }
}

