/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class CreateServiceInstanceRequest {
    private final String serviceInstanceName;
    private final String name;
    private final String plan;
    private final Map<String, Object> parameters;
    private final Map<String, String> properties;

    protected CreateServiceInstanceRequest(String serviceInstanceName, String name, String plan, Map<String, Object> parameters, Map<String, String> properties) {
        this.serviceInstanceName = serviceInstanceName;
        this.name = name;
        this.plan = plan;
        this.parameters = parameters;
        this.properties = properties;
    }

    public static CreateServiceInstanceRequestBuilder builder() {
        return new CreateServiceInstanceRequestBuilder();
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public String getName() {
        return this.name;
    }

    public String getPlan() {
        return this.plan;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class CreateServiceInstanceRequestBuilder {
        private String serviceInstanceName;
        private String name;
        private String plan;
        private final Map<String, Object> parameters = new HashMap<String, Object>();
        private final Map<String, String> properties = new HashMap<String, String>();

        private CreateServiceInstanceRequestBuilder() {
        }

        public CreateServiceInstanceRequestBuilder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public CreateServiceInstanceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateServiceInstanceRequestBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public CreateServiceInstanceRequestBuilder parameters(String key, String value) {
            if (key != null && value != null) {
                this.parameters.put(key, value);
            }
            return this;
        }

        public CreateServiceInstanceRequestBuilder parameters(Map<String, Object> parameters) {
            if (!CollectionUtils.isEmpty(parameters)) {
                this.parameters.putAll(parameters);
            }
            return this;
        }

        public CreateServiceInstanceRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public CreateServiceInstanceRequest build() {
            return new CreateServiceInstanceRequest(this.serviceInstanceName, this.name, this.plan, this.parameters, this.properties);
        }
    }
}

