/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import java.util.Map;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class CloudFoundryOperationsUtils {
    private final CloudFoundryOperations operations;

    public CloudFoundryOperationsUtils(CloudFoundryOperations operations) {
        this.operations = operations;
    }

    protected Mono<CloudFoundryOperations> getOperations(Map<String, String> properties) {
        return Mono.defer(() -> {
            if (!CollectionUtils.isEmpty((Map)properties) && properties.containsKey("target")) {
                return this.getOperationsForSpace((String)properties.get("target"));
            }
            return Mono.just((Object)this.operations);
        });
    }

    protected Mono<CloudFoundryOperations> getOperationsForSpace(String space) {
        return Mono.just((Object)this.operations).cast(DefaultCloudFoundryOperations.class).map(cfOperations -> DefaultCloudFoundryOperations.builder().from(cfOperations).space(space).build());
    }

    protected Mono<CloudFoundryOperations> getOperationsForOrgAndSpace(String organization, String space) {
        return Mono.just((Object)this.operations).cast(DefaultCloudFoundryOperations.class).map(cfOperations -> DefaultCloudFoundryOperations.builder().from(cfOperations).organization(organization).space(space).build());
    }
}

