/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.springframework.cloud.appbroker.deployer.DeploymentProperties;

public class CloudFoundryDeploymentProperties
extends DeploymentProperties {
    protected static final String HEALTHCHECK_PROPERTY_KEY = "health-check";
    protected static final String HEALTHCHECK_HTTP_ENDPOINT_PROPERTY_KEY = "health-check-http-endpoint";
    protected static final String HEALTHCHECK_TIMEOUT_PROPERTY_KEY = "health-check-timeout";
    protected static final String API_POLLING_TIMEOUT_PROPERTY_KEY = "api-polling-timeout";
    protected static final String ROUTE_PATH_PROPERTY = "route-path";
    protected static final String ROUTES_PROPERTY = "routes";
    protected static final String NO_ROUTE_PROPERTY = "no-route";
    protected static final String DOMAIN_PROPERTY = "domain";
    protected static final String DOMAINS_PROPERTY = "domains";
    protected static final String BUILDPACK_PROPERTY_KEY = "buildpack";
    protected static final String JAVA_OPTS_PROPERTY_KEY = "javaOpts";
    public static final long DEFAULT_API_POLLING_TIMEOUT_SECONDS = Duration.ofMinutes(5L).getSeconds();
    private String domain;
    private Set<String> domains = new HashSet<String>();
    private Set<String> routes = new HashSet<String>();
    private String buildpack = "";
    private ApplicationHealthCheck healthCheck;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckTimeout;
    private boolean enableRandomAppNamePrefix = true;
    private long apiTimeout = 360L;
    private long apiPollingTimeout = DEFAULT_API_POLLING_TIMEOUT_SECONDS;
    private long statusTimeout = 5000L;
    private Duration stagingTimeout = Duration.ofMinutes(15L);
    private Duration startupTimeout = Duration.ofMinutes(5L);
    private boolean deleteRoutes = true;
    private String javaOpts;

    public String getBuildpack() {
        return this.buildpack;
    }

    public void setBuildpack(String buildpack) {
        this.buildpack = buildpack;
    }

    public boolean isEnableRandomAppNamePrefix() {
        return this.enableRandomAppNamePrefix;
    }

    public void setEnableRandomAppNamePrefix(boolean enableRandomAppNamePrefix) {
        this.enableRandomAppNamePrefix = enableRandomAppNamePrefix;
    }

    public long getApiTimeout() {
        return this.apiTimeout;
    }

    public void setApiTimeout(long apiTimeout) {
        this.apiTimeout = apiTimeout;
    }

    public ApplicationHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(ApplicationHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    public void setHealthCheckHttpEndpoint(String healthCheckHttpEndpoint) {
        this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
    }

    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(Integer healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    public Set<String> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Set<String> routes) {
        this.routes = routes;
    }

    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    public void setStagingTimeout(Duration stagingTimeout) {
        this.stagingTimeout = stagingTimeout;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public long getStatusTimeout() {
        return this.statusTimeout;
    }

    public void setStatusTimeout(long statusTimeout) {
        this.statusTimeout = statusTimeout;
    }

    public boolean isDeleteRoutes() {
        return this.deleteRoutes;
    }

    public void setDeleteRoutes(boolean deleteRoutes) {
        this.deleteRoutes = deleteRoutes;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public long getApiPollingTimeout() {
        return this.apiPollingTimeout;
    }

    public void setApiPollingTimeout(long apiPollingTimeout) {
        this.apiPollingTimeout = apiPollingTimeout;
    }
}

