/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.organizations.GetOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstanceEntity;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperRequest;
import org.cloudfoundry.client.v2.spaces.CreateSpaceRequest;
import org.cloudfoundry.client.v2.spaces.DeleteSpaceRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.cloudfoundry.client.v3.builds.BuildState;
import org.cloudfoundry.client.v3.builds.CreateBuildRequest;
import org.cloudfoundry.client.v3.builds.CreateBuildResponse;
import org.cloudfoundry.client.v3.builds.GetBuildRequest;
import org.cloudfoundry.client.v3.builds.GetBuildResponse;
import org.cloudfoundry.client.v3.deployments.CreateDeploymentRequest;
import org.cloudfoundry.client.v3.deployments.CreateDeploymentResponse;
import org.cloudfoundry.client.v3.deployments.DeploymentRelationships;
import org.cloudfoundry.client.v3.deployments.DeploymentState;
import org.cloudfoundry.client.v3.deployments.GetDeploymentRequest;
import org.cloudfoundry.client.v3.deployments.GetDeploymentResponse;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.PackageRelationships;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.organizations.OrganizationDetail;
import org.cloudfoundry.operations.organizations.OrganizationInfoRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.operations.services.ServiceInstance;
import org.cloudfoundry.operations.services.UnbindServiceInstanceRequest;
import org.cloudfoundry.operations.useradmin.SetSpaceRoleRequest;
import org.cloudfoundry.operations.useradmin.SpaceRole;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.deployer.AppDeployer;
import org.springframework.cloud.appbroker.deployer.CreateServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.CreateServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.DeleteServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.DeleteServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.DeployApplicationRequest;
import org.springframework.cloud.appbroker.deployer.DeployApplicationResponse;
import org.springframework.cloud.appbroker.deployer.GetServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.GetServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.UndeployApplicationRequest;
import org.springframework.cloud.appbroker.deployer.UndeployApplicationResponse;
import org.springframework.cloud.appbroker.deployer.UpdateApplicationRequest;
import org.springframework.cloud.appbroker.deployer.UpdateApplicationResponse;
import org.springframework.cloud.appbroker.deployer.UpdateServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.UpdateServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOperationsUtils;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryTargetProperties;
import org.springframework.cloud.appbroker.deployer.util.ByteSizeUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryAppDeployer
implements AppDeployer,
ResourceLoaderAware {
    private final Logger logger = LoggerFactory.getLogger(CloudFoundryAppDeployer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final CloudFoundryDeploymentProperties defaultDeploymentProperties;
    private final CloudFoundryOperations operations;
    private final CloudFoundryClient client;
    private final CloudFoundryOperationsUtils operationsUtils;
    private final CloudFoundryTargetProperties targetProperties;
    private ResourceLoader resourceLoader;

    public CloudFoundryAppDeployer(CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, CloudFoundryClient client, CloudFoundryOperationsUtils operationsUtils, CloudFoundryTargetProperties targetProperties, ResourceLoader resourceLoader) {
        this.defaultDeploymentProperties = deploymentProperties;
        this.operations = operations;
        this.client = client;
        this.operationsUtils = operationsUtils;
        this.targetProperties = targetProperties;
        this.resourceLoader = resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Mono<DeployApplicationResponse> deploy(DeployApplicationRequest request) {
        String appName = request.getName();
        Resource appResource = this.getAppResource(request.getPath());
        Map deploymentProperties = request.getProperties();
        this.logger.trace("Deploying application: request={}, resource={}", (Object)appName, (Object)appResource);
        return this.pushApplication(request, deploymentProperties, appResource).timeout(Duration.ofSeconds(this.defaultDeploymentProperties.getApiTimeout())).doOnSuccess(item -> this.logger.info("Successfully deployed {}", (Object)appName)).doOnError(error -> {
            if (this.isNotFoundError().test((Throwable)error)) {
                this.logger.warn("Unable to deploy application. It may have been destroyed before start completed: " + error.getMessage());
            } else {
                this.logError(String.format("Failed to deploy %s", appName)).accept((Throwable)error);
            }
        }).thenReturn((Object)DeployApplicationResponse.builder().name(appName).build());
    }

    public Mono<UpdateApplicationResponse> update(UpdateApplicationRequest request) {
        String name = request.getName();
        Map<String, Object> environmentVariables = this.getApplicationEnvironment(request.getProperties(), request.getEnvironment(), request.getServiceInstanceId());
        return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.applications().get(GetApplicationRequest.builder().name(name).build()).doOnRequest(l -> this.logger.debug("Getting application {}", (Object)name)).doOnSuccess(response -> this.logger.info("Success getting application {}", (Object)name)).doOnError(e -> this.logger.warn(String.format("Error getting application %s: %s", name, e.getMessage()))).map(ApplicationDetail::getId).flatMap(applicationId -> this.updateApplicationEnvironment((String)applicationId, environmentVariables, request.getProperties()).thenReturn(applicationId)).flatMap(applicationId -> Mono.zip((Mono)Mono.just((Object)applicationId), this.createPackageForApplication((String)applicationId))).map(tuple2 -> tuple2.mapT2(CreatePackageResponse::getId)).flatMap(tuple2 -> {
            String packageId = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)tuple2.getT1()), this.uploadPackage(request, packageId));
        }).map(tuple2 -> tuple2.mapT2(org.cloudfoundry.client.v3.Resource::getId)).flatMap(tuple2 -> {
            String packageId1 = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)tuple2.getT1()), this.waitForPackageReady(packageId1));
        }).map(tuple2 -> tuple2.mapT2(org.cloudfoundry.client.v3.Resource::getId)).flatMap(tuple2 -> {
            String packageId = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)tuple2.getT1()), this.createBuildForPackage(packageId));
        }).flatMap(tuple2 -> {
            String buildId = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)tuple2.getT1()), this.waitForBuildStaged(buildId));
        }).map(tuple2 -> tuple2.mapT2(t2 -> t2.getDroplet().getId())).flatMap(tuple2 -> {
            String dropletId = (String)tuple2.getT2();
            String applicationId = (String)tuple2.getT1();
            return this.createDeployment(dropletId, applicationId);
        }).map(CreateDeploymentResponse::getId).flatMap(this::waitForDeploymentDeployed).doOnRequest(l -> this.logger.debug("Updating application {}", (Object)name)).doOnSuccess(item -> this.logger.info("Successfully updated application {}", (Object)name)).doOnError(error -> this.logger.error("Failed to update application {}", (Object)name)).thenReturn((Object)UpdateApplicationResponse.builder().name(name).build()));
    }

    private Mono<GetDeploymentResponse> waitForDeploymentDeployed(String deploymentId) {
        return this.client.deploymentsV3().get(GetDeploymentRequest.builder().deploymentId(deploymentId).build()).filter(p -> p.getState().equals((Object)DeploymentState.DEPLOYED)).repeatWhenEmpty(this.getExponentialBackOff()).doOnRequest(l -> this.logger.debug("Waiting for deployment deployed {}", (Object)deploymentId)).doOnSuccess(response -> this.logger.info("Deployment deployed {}", (Object)deploymentId)).doOnError(e -> this.logger.warn(String.format("Error waiting for deployment deployed %s: %s", deploymentId, e.getMessage())));
    }

    private Mono<CreateDeploymentResponse> createDeployment(String dropletId, String applicationId) {
        return this.client.deploymentsV3().create(CreateDeploymentRequest.builder().droplet(Relationship.builder().id(dropletId).build()).relationships(DeploymentRelationships.builder().app(ToOneRelationship.builder().data(Relationship.builder().id(applicationId).build()).build()).build()).build()).doOnRequest(l -> this.logger.debug("Creating deployment for application {}", (Object)applicationId)).doOnSuccess(response -> this.logger.info("Created deployment for application {}", (Object)applicationId)).doOnError(e -> this.logger.warn(String.format("Error creating deployment for application %s: %s", applicationId, e.getMessage())));
    }

    private Mono<GetBuildResponse> waitForBuildStaged(String buildId) {
        return this.client.builds().get(GetBuildRequest.builder().buildId(buildId).build()).filter(p -> p.getState().equals((Object)BuildState.STAGED)).repeatWhenEmpty(this.getExponentialBackOff()).doOnRequest(l -> this.logger.debug("Waiting for build staged {}", (Object)buildId)).doOnSuccess(response -> this.logger.info("Build staged {}", (Object)buildId)).doOnError(e -> this.logger.warn(String.format("Error waiting for build staged %s: %s", buildId, e.getMessage())));
    }

    private Mono<String> createBuildForPackage(String packageId) {
        return this.client.builds().create(CreateBuildRequest.builder().getPackage(Relationship.builder().id(packageId).build()).build()).map(CreateBuildResponse::getId).doOnRequest(l -> this.logger.debug("Creating build for package {}", (Object)packageId)).doOnSuccess(response -> this.logger.info("Created build for package {}", (Object)packageId)).doOnError(e -> this.logger.warn(String.format("Error creating build package %s: %s", packageId, e.getMessage())));
    }

    private Mono<GetPackageResponse> waitForPackageReady(String packageId) {
        return this.client.packages().get(GetPackageRequest.builder().packageId(packageId).build()).filter(p -> p.getState().equals((Object)PackageState.READY)).repeatWhenEmpty(this.getExponentialBackOff()).doOnRequest(l -> this.logger.debug("Waiting for package ready {}", (Object)packageId)).doOnSuccess(response -> this.logger.info("Package ready {}", (Object)packageId)).doOnError(e -> this.logger.warn(String.format("Error waiting for package ready %s: %s", packageId, e.getMessage())));
    }

    private Mono<UploadPackageResponse> uploadPackage(UpdateApplicationRequest request, String packageId) {
        try {
            return this.client.packages().upload(UploadPackageRequest.builder().packageId(packageId).bits(Paths.get(this.getAppResource(request.getPath()).getURI())).build()).doOnRequest(l -> this.logger.debug("Uploading package {}", (Object)packageId)).doOnSuccess(response -> this.logger.info("Package uploaded {}", (Object)packageId)).doOnError(e -> this.logger.warn(String.format("Error uploading package %s: %s", packageId, e.getMessage())));
        }
        catch (IOException e2) {
            throw Exceptions.propagate((Throwable)e2);
        }
    }

    private Mono<CreatePackageResponse> createPackageForApplication(String applicationId) {
        return this.client.packages().create(CreatePackageRequest.builder().relationships(PackageRelationships.builder().application(ToOneRelationship.builder().data(Relationship.builder().id(applicationId).build()).build()).build()).type(PackageType.BITS).build()).doOnRequest(l -> this.logger.debug("Creating package for application {}", (Object)applicationId)).doOnSuccess(response -> this.logger.info("Created package for application {}", (Object)applicationId)).doOnError(e -> this.logger.warn(String.format("Error creating package for application %s: %s", applicationId, e.getMessage())));
    }

    private Mono<org.cloudfoundry.client.v2.applications.UpdateApplicationResponse> updateApplicationEnvironment(String applicationId, Map<String, Object> environmentVariables, Map<String, String> properties) {
        return this.client.applicationsV2().update(org.cloudfoundry.client.v2.applications.UpdateApplicationRequest.builder().applicationId(applicationId).instances(this.instances(properties)).diskQuota(this.diskQuota(properties)).memory(this.memory(properties)).putAllEnvironmentJsons(environmentVariables).build()).doOnRequest(l -> this.logger.debug("Updating environment for application {}", (Object)applicationId)).doOnSuccess(response -> this.logger.info("Updated environment for application {}", (Object)applicationId)).doOnError(e -> this.logger.warn(String.format("Error Updating environment for application %s: %s", applicationId, e.getMessage())));
    }

    private Function<Flux<Long>, Publisher<?>> getExponentialBackOff() {
        return DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMinutes(5L), (Duration)Duration.ofMinutes(10L));
    }

    private Mono<Void> pushApplication(DeployApplicationRequest request, Map<String, String> deploymentProperties, Resource appResource) {
        Mono<Void> requestPushApplication;
        ApplicationManifest manifest = this.buildAppManifest(request, deploymentProperties, appResource);
        this.logger.debug("Pushing manifest" + manifest.toString());
        PushApplicationManifestRequest applicationManifestRequest = PushApplicationManifestRequest.builder().manifest(manifest).stagingTimeout(this.defaultDeploymentProperties.getStagingTimeout()).startupTimeout(this.defaultDeploymentProperties.getStartupTimeout()).noStart(Boolean.valueOf(this.start(deploymentProperties) == false)).build();
        if (deploymentProperties.containsKey("target")) {
            String space = deploymentProperties.get("target");
            requestPushApplication = this.pushManifestInSpace(applicationManifestRequest, space);
        } else {
            requestPushApplication = this.pushManifest(applicationManifestRequest);
        }
        return requestPushApplication.doOnSuccess(v -> this.logger.info("Done uploading bits for {}", (Object)request.getName())).doOnError(e -> this.logger.error(String.format("Error creating app %s.  Exception Message %s", request.getName(), e.getMessage())));
    }

    private ApplicationManifest buildAppManifest(DeployApplicationRequest request, Map<String, String> deploymentProperties, Resource appResource) {
        ApplicationManifest.Builder manifest = ApplicationManifest.builder().name(request.getName()).path(this.getApplication(appResource)).environmentVariables(this.getEnvironmentVariables(deploymentProperties, request.getEnvironment(), request.getServiceInstanceId())).services((Iterable)request.getServices()).instances(this.instances(deploymentProperties)).memory(this.memory(deploymentProperties)).disk(this.diskQuota(deploymentProperties)).healthCheckType(this.healthCheck(deploymentProperties)).healthCheckHttpEndpoint(this.healthCheckEndpoint(deploymentProperties)).timeout(this.healthCheckTimeout(deploymentProperties)).noRoute(this.toggleNoRoute(deploymentProperties));
        Optional.ofNullable(this.host(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).host(arg_0));
        Optional.ofNullable(this.domain(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).domain(arg_0));
        Optional.ofNullable(this.routePath(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).routePath(arg_0));
        if (this.route(deploymentProperties) != null) {
            manifest.route(Route.builder().route(this.route(deploymentProperties)).build());
        }
        if (!this.routes(deploymentProperties).isEmpty()) {
            Set routes = this.routes(deploymentProperties).stream().map(r -> Route.builder().route(r).build()).collect(Collectors.toSet());
            manifest.routes(routes);
        }
        if (this.getDockerImage(appResource) == null) {
            manifest.buildpack(this.buildpack(deploymentProperties));
        } else {
            manifest.docker(Docker.builder().image(this.getDockerImage(appResource)).build());
        }
        return manifest.build();
    }

    private Mono<Void> pushManifest(PushApplicationManifestRequest request) {
        return this.operations.applications().pushManifest(request);
    }

    private Mono<Void> pushManifestInSpace(PushApplicationManifestRequest request, String spaceName) {
        return this.createSpace(spaceName).then(this.operationsUtils.getOperationsForSpace(spaceName)).flatMap(cfOperations -> cfOperations.applications().pushManifest(request));
    }

    private Mono<String> createSpace(String spaceName) {
        return this.getSpaceId(spaceName).switchIfEmpty(Mono.justOrEmpty((Object)this.targetProperties.getDefaultOrg()).flatMap(orgName -> this.getOrganizationId((String)orgName).flatMap(orgId -> this.client.spaces().create(CreateSpaceRequest.builder().organizationId(orgId).name(spaceName).build()).doOnSuccess(response -> this.logger.info("Created space {}", (Object)spaceName)).doOnError(e -> this.logger.warn(String.format("Error creating space %s: %s", spaceName, e.getMessage()))).map(response -> response.getMetadata().getId()).flatMap(spaceId -> this.setSpaceDeveloperRoleForCurrentUser((String)orgName, spaceName, (String)spaceId).thenReturn(spaceId)))));
    }

    private Mono<Void> setSpaceDeveloperRoleForCurrentUser(String orgName, String spaceName, String spaceId) {
        return Mono.defer(() -> {
            if (StringUtils.hasText((String)this.targetProperties.getClientId())) {
                return this.client.spaces().associateDeveloper(AssociateSpaceDeveloperRequest.builder().spaceId(spaceId).developerId(this.targetProperties.getClientId()).build()).doOnSuccess(v -> this.logger.info("Set space developer role for space {}", (Object)spaceName)).doOnError(e -> this.logger.warn(String.format("Error setting space developer role for space %s: %s", spaceName, e.getMessage()))).then();
            }
            if (StringUtils.hasText((String)this.targetProperties.getUsername())) {
                return this.operations.userAdmin().setSpaceRole(SetSpaceRoleRequest.builder().spaceRole(SpaceRole.DEVELOPER).organizationName(orgName).spaceName(spaceName).username(this.targetProperties.getUsername()).build()).doOnSuccess(v -> this.logger.info("Set space developer role for space {}", (Object)spaceName)).doOnError(e -> this.logger.warn(String.format("Error setting space developer role for space %s: %s", spaceName, e.getMessage())));
            }
            return Mono.empty();
        });
    }

    private Mono<String> getOrganizationId(String orgName) {
        return this.operations.organizations().get(OrganizationInfoRequest.builder().name(orgName).build()).map(OrganizationDetail::getId);
    }

    public Mono<UndeployApplicationResponse> undeploy(UndeployApplicationRequest request) {
        Mono requestDeleteApplication;
        this.logger.trace("Undeploying application: request={}", (Object)request);
        String appName = request.getName();
        Map deploymentProperties = request.getProperties();
        if (deploymentProperties.containsKey("target")) {
            String space = (String)deploymentProperties.get("target");
            requestDeleteApplication = this.deleteApplicationInSpace(appName, space).then(this.deleteSpace(space));
        } else {
            requestDeleteApplication = this.deleteApplication(appName);
        }
        return requestDeleteApplication.timeout(Duration.ofSeconds(this.defaultDeploymentProperties.getApiTimeout())).doOnSuccess(v -> this.logger.info("Successfully undeployed app {}", (Object)appName)).doOnError(this.logError(String.format("Failed to undeploy app %s", appName))).then(Mono.just((Object)UndeployApplicationResponse.builder().name(appName).build()));
    }

    private Mono<Void> deleteApplication(String name) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.defaultDeploymentProperties.isDeleteRoutes())).name(name).build());
    }

    private Mono<Void> deleteApplicationInSpace(String name, String spaceName) {
        return this.getSpaceId(spaceName).doOnError(error -> this.logger.warn("Unable to get space name: {} ", (Object)spaceName)).then(this.operationsUtils.getOperationsForSpace(spaceName)).flatMap(cfOperations -> cfOperations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.defaultDeploymentProperties.isDeleteRoutes())).name(name).build()).doOnError(error -> this.logger.warn("Unable to delete application: {} ", (Object)name))).onErrorResume(e -> Mono.empty());
    }

    private Mono<Void> deleteSpace(String spaceName) {
        return this.getSpaceId(spaceName).doOnError(error -> this.logger.warn("Unable to get space name: {} ", (Object)spaceName)).flatMap(spaceId -> this.client.spaces().delete(DeleteSpaceRequest.builder().spaceId(spaceId).build()).then(Mono.empty()));
    }

    private Mono<String> getSpaceId(String spaceName) {
        return Mono.justOrEmpty((Object)this.targetProperties.getDefaultOrg()).flatMap(orgName -> this.getOrganizationId((String)orgName).flatMap(orgId -> PaginationUtils.requestClientV2Resources(page -> this.client.organizations().listSpaces(ListOrganizationSpacesRequest.builder().name(spaceName).organizationId(orgId).page(page).build())).filter(resource -> resource.getEntity().getName().equals(spaceName)).map(resource -> resource.getMetadata().getId()).next()));
    }

    private Map<String, Object> getEnvironmentVariables(Map<String, String> properties, Map<String, Object> environment, String serviceInstanceId) {
        Map<String, Object> envVariables = this.getApplicationEnvironment(properties, environment, serviceInstanceId);
        String javaOpts = this.javaOpts(properties);
        if (StringUtils.hasText((String)javaOpts)) {
            envVariables.put("JAVA_OPTS", javaOpts);
        }
        return envVariables;
    }

    private Map<String, Object> getApplicationEnvironment(Map<String, String> properties, Map<String, Object> environment, String serviceInstanceId) {
        Map<String, Object> applicationEnvironment = this.sanitizeApplicationEnvironment(environment);
        if (serviceInstanceId != null) {
            applicationEnvironment.put("spring.cloud.appbroker.service-instance-id", serviceInstanceId);
        }
        if (!applicationEnvironment.isEmpty() && this.useSpringApplicationJson(properties)) {
            try {
                String jsonEnvironment = OBJECT_MAPPER.writeValueAsString(applicationEnvironment);
                applicationEnvironment = new HashMap<String, Object>(1);
                applicationEnvironment.put("SPRING_APPLICATION_JSON", jsonEnvironment);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error writing environment to SPRING_APPLICATION_JSON", e);
            }
        }
        return applicationEnvironment;
    }

    private Map<String, Object> sanitizeApplicationEnvironment(Map<String, Object> environment) {
        HashMap<String, Object> applicationEnvironment = new HashMap<String, Object>(environment);
        Optional.ofNullable(applicationEnvironment.remove("server.port")).ifPresent(port -> this.logger.warn("Ignoring 'server.port={}', as Cloud Foundry will assign a local dynamic port. Route to the app will use port 80.", port));
        return applicationEnvironment;
    }

    private boolean useSpringApplicationJson(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("use-spring-application-json")).map(Boolean::valueOf).orElse(this.defaultDeploymentProperties.isUseSpringApplicationJson());
    }

    private String domain(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("domain")).orElse(this.defaultDeploymentProperties.getDomain());
    }

    private ApplicationHealthCheck healthCheck(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check")).map(this::toApplicationHealthCheck).orElse(this.defaultDeploymentProperties.getHealthCheck());
    }

    private ApplicationHealthCheck toApplicationHealthCheck(String raw) {
        try {
            return ApplicationHealthCheck.from((String)raw);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported health-check value '%s'. Available values are %s", raw, StringUtils.arrayToCommaDelimitedString((Object[])ApplicationHealthCheck.values())), e);
        }
    }

    private String healthCheckEndpoint(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check-http-endpoint")).orElse(this.defaultDeploymentProperties.getHealthCheckHttpEndpoint());
    }

    private Integer healthCheckTimeout(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check-timeout")).map(Integer::parseInt).orElse(this.defaultDeploymentProperties.getHealthCheckTimeout());
    }

    private Integer instances(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("count")).map(Integer::parseInt).orElse(this.defaultDeploymentProperties.getCount());
    }

    private String host(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("host")).orElse(this.defaultDeploymentProperties.getHost());
    }

    private String routePath(Map<String, String> properties) {
        String routePath = properties.get("route-path");
        if (StringUtils.hasText((String)routePath) && routePath.charAt(0) != '/') {
            throw new IllegalArgumentException("Cloud Foundry routes must start with \"/\". Route passed = [" + routePath + "].");
        }
        return routePath;
    }

    private String route(Map<String, String> properties) {
        return properties.get("route");
    }

    private Set<String> routes(Map<String, String> properties) {
        HashSet<String> routes = new HashSet<String>();
        routes.addAll(this.defaultDeploymentProperties.getRoutes());
        routes.addAll(StringUtils.commaDelimitedListToSet((String)properties.get("routes")));
        return routes;
    }

    private Boolean toggleNoRoute(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("no-route")).map(Boolean::valueOf).orElse(null);
    }

    private Integer memory(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("memory")).map(ByteSizeUtils::parseToMebibytes).orElse(ByteSizeUtils.parseToMebibytes((String)this.defaultDeploymentProperties.getMemory()));
    }

    private Integer diskQuota(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("disk")).map(ByteSizeUtils::parseToMebibytes).orElse(ByteSizeUtils.parseToMebibytes((String)this.defaultDeploymentProperties.getDisk()));
    }

    private String buildpack(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("buildpack")).orElse(this.defaultDeploymentProperties.getBuildpack());
    }

    private String javaOpts(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("javaOpts")).orElse(this.defaultDeploymentProperties.getJavaOpts());
    }

    private Boolean start(Map<String, String> deploymentProperties) {
        return Optional.ofNullable(deploymentProperties.get("start")).map(Boolean::valueOf).orElse(true);
    }

    private Predicate<Throwable> isNotFoundError() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }

    private String getDockerImage(Resource resource) {
        try {
            String uri = resource.getURI().toString();
            if (uri.startsWith("docker:")) {
                return uri.substring("docker:".length());
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Resource getAppResource(String path) {
        return this.resourceLoader.getResource(path);
    }

    private Path getApplication(Resource resource) {
        try {
            if (resource.getURI().toString().startsWith("docker:")) {
                return null;
            }
            return resource.getFile().toPath();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Mono<GetServiceInstanceResponse> getServiceInstance(GetServiceInstanceRequest request) {
        return Mono.defer(() -> {
            if (StringUtils.hasText((String)request.getServiceInstanceId())) {
                return this.getServiceInstance(request.getServiceInstanceId()).flatMap(serviceInstanceEntity -> this.getSpace(serviceInstanceEntity.getSpaceId()).flatMap(spaceEntity -> this.getServiceInstance(serviceInstanceEntity.getName(), (SpaceEntity)spaceEntity)));
            }
            return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.services().getInstance(org.cloudfoundry.operations.services.GetServiceInstanceRequest.builder().name(request.getName()).build()));
        }).map(serviceInstance -> GetServiceInstanceResponse.builder().name(serviceInstance.getName()).service(serviceInstance.getService()).plan(serviceInstance.getPlan()).build());
    }

    private Mono<ServiceInstance> getServiceInstance(String name, SpaceEntity spaceEntity) {
        return this.getOrganization(spaceEntity.getOrganizationId()).flatMap(organizationEntity -> this.operationsUtils.getOperationsForOrgAndSpace(organizationEntity.getName(), spaceEntity.getName()).flatMap(cfOperations -> cfOperations.services().getInstance(org.cloudfoundry.operations.services.GetServiceInstanceRequest.builder().name(name).build())));
    }

    private Mono<ServiceInstanceEntity> getServiceInstance(String serviceInstanceId) {
        return this.client.serviceInstances().get(org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceRequest.builder().serviceInstanceId(serviceInstanceId).build()).map(ResourceUtils::getEntity);
    }

    private Mono<SpaceEntity> getSpace(String spaceId) {
        return this.client.spaces().get(GetSpaceRequest.builder().spaceId(spaceId).build()).map(ResourceUtils::getEntity);
    }

    private Mono<OrganizationEntity> getOrganization(String organizationId) {
        return this.client.organizations().get(GetOrganizationRequest.builder().organizationId(organizationId).build()).map(GetOrganizationResponse::getEntity);
    }

    public Mono<CreateServiceInstanceResponse> createServiceInstance(CreateServiceInstanceRequest request) {
        org.cloudfoundry.operations.services.CreateServiceInstanceRequest createServiceInstanceRequest = org.cloudfoundry.operations.services.CreateServiceInstanceRequest.builder().serviceInstanceName(request.getServiceInstanceName()).serviceName(request.getName()).planName(request.getPlan()).parameters(request.getParameters()).build();
        Mono createServiceInstanceResponseMono = Mono.just((Object)CreateServiceInstanceResponse.builder().name(request.getServiceInstanceName()).build());
        if (request.getProperties().containsKey("target")) {
            return this.createSpace((String)request.getProperties().get("target")).then(this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.services().createInstance(createServiceInstanceRequest).then(createServiceInstanceResponseMono)));
        }
        return this.operations.services().createInstance(createServiceInstanceRequest).then(createServiceInstanceResponseMono);
    }

    public Mono<UpdateServiceInstanceResponse> updateServiceInstance(UpdateServiceInstanceRequest request) {
        return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> this.rebindServiceInstanceIfNecessary(request, (CloudFoundryOperations)cfOperations).then(this.updateServiceInstanceIfNecessary(request, (CloudFoundryOperations)cfOperations)));
    }

    public Mono<DeleteServiceInstanceResponse> deleteServiceInstance(DeleteServiceInstanceRequest request) {
        return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> Mono.just((Object)request.getServiceInstanceName()).flatMap(serviceInstanceName -> this.unbindServiceInstance((String)serviceInstanceName, (CloudFoundryOperations)cfOperations).then(this.deleteServiceInstance((String)serviceInstanceName, (CloudFoundryOperations)cfOperations).thenReturn((Object)DeleteServiceInstanceResponse.builder().name(serviceInstanceName).build()))));
    }

    private Mono<Void> deleteServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations) {
        return cloudFoundryOperations.services().deleteInstance(org.cloudfoundry.operations.services.DeleteServiceInstanceRequest.builder().name(serviceInstanceName).build());
    }

    private Mono<Void> unbindServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations) {
        return cloudFoundryOperations.services().getInstance(org.cloudfoundry.operations.services.GetServiceInstanceRequest.builder().name(serviceInstanceName).build()).map(ServiceInstance::getApplications).flatMap(applications -> Flux.fromIterable((Iterable)applications).flatMap(application -> cloudFoundryOperations.services().unbind(UnbindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build())).then(Mono.empty()));
    }

    private Mono<Void> rebindServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations) {
        return cloudFoundryOperations.services().getInstance(org.cloudfoundry.operations.services.GetServiceInstanceRequest.builder().name(serviceInstanceName).build()).map(ServiceInstance::getApplications).flatMap(applications -> Flux.fromIterable((Iterable)applications).flatMap(application -> cloudFoundryOperations.services().unbind(UnbindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build()).then(cloudFoundryOperations.services().bind(BindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build()))).then(Mono.empty()));
    }

    private Mono<Void> rebindServiceInstanceIfNecessary(UpdateServiceInstanceRequest request, CloudFoundryOperations cloudFoundryOperations) {
        if (request.isRebindOnUpdate()) {
            return this.rebindServiceInstance(request.getServiceInstanceName(), cloudFoundryOperations);
        }
        return Mono.empty();
    }

    private Mono<UpdateServiceInstanceResponse> updateServiceInstanceIfNecessary(UpdateServiceInstanceRequest request, CloudFoundryOperations cloudFoundryOperations) {
        if (request.getParameters() == null || request.getParameters().isEmpty()) {
            return Mono.empty();
        }
        String serviceInstanceName = request.getServiceInstanceName();
        return cloudFoundryOperations.services().updateInstance(org.cloudfoundry.operations.services.UpdateServiceInstanceRequest.builder().serviceInstanceName(serviceInstanceName).parameters(request.getParameters()).build()).then(Mono.just((Object)UpdateServiceInstanceResponse.builder().name(serviceInstanceName).build()));
    }

    private Consumer<Throwable> logError(String msg) {
        return e -> {
            if (e instanceof UnknownCloudFoundryException) {
                this.logger.error(msg + "\nUnknownCloudFoundryException encountered, whose payload follows:\n" + ((UnknownCloudFoundryException)e).getPayload(), e);
            } else {
                this.logger.error(msg, e);
            }
        };
    }
}

