/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.autoconfigure;

import org.cloudfoundry.logcache.v1.LogCacheClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.appbroker.logging.ApplicationIdsProvider;
import org.springframework.cloud.appbroker.logging.recent.ApplicationRecentLogsProvider;
import org.springframework.cloud.appbroker.logging.recent.RecentLogsProvider;
import org.springframework.cloud.appbroker.logging.recent.endpoint.RecentLogsController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ApplicationRecentLogsProvider.class})
@ConditionalOnBean(value={ApplicationIdsProvider.class})
public class ServiceInstanceRecentLogsAutoConfiguration {
    @Bean
    public RecentLogsProvider recentLogsProvider(LogCacheClient logCacheClient, ApplicationIdsProvider applicationIdsProvider) {
        return new ApplicationRecentLogsProvider(logCacheClient, applicationIdsProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public RecentLogsController recentLogsController(RecentLogsProvider recentLogsProvider) {
        return new RecentLogsController(recentLogsProvider);
    }
}

