/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource;

import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.util.StringUtils;

public enum RuleType {
    FLOW("flow", FlowRule.class),
    DEGRADE("degrade", DegradeRule.class),
    PARAM_FLOW("param-flow", ParamFlowRule.class),
    SYSTEM("system", SystemRule.class),
    AUTHORITY("authority", AuthorityRule.class);

    private final String name;
    private final Class clazz;

    private RuleType(String name, Class clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public static Optional<RuleType> getByName(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return Optional.empty();
        }
        return Arrays.stream(RuleType.values()).filter(ruleType -> name.equals(ruleType.getName())).findFirst();
    }

    public static Optional<RuleType> getByClass(Class clazz) {
        return Arrays.stream(RuleType.values()).filter(ruleType -> clazz == ruleType.getClazz()).findFirst();
    }
}

