/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.cli;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.compiler.RepositoryConfigurationFactory;
import org.springframework.boot.cli.compiler.grape.AetherGrapeEngine;
import org.springframework.boot.cli.compiler.grape.AetherGrapeEngineFactory;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.util.StringUtils;

public class LauncherCommand
extends OptionParsingCommand {
    public static final Log log = LogFactory.getLog(LauncherCommand.class);
    private static final String DEFAULT_VERSION = "1.2.3.RELEASE";
    private static final Collection<HelpExample> EXAMPLES = new ArrayList<HelpExample>();

    public LauncherCommand() {
        super("cloud", "Start Spring Cloud services, like Eureka, Config Server, etc.", (OptionHandler)new LauncherOptionHandler());
    }

    public Collection<HelpExample> getExamples() {
        return EXAMPLES;
    }

    static {
        EXAMPLES.add(new HelpExample("Launch Eureka", "spring cloud eureka"));
        EXAMPLES.add(new HelpExample("Launch Config Server and Eureka", "spring cloud configserver eureka"));
        EXAMPLES.add(new HelpExample("List deployable apps", "spring cloud --list"));
        EXAMPLES.add(new HelpExample("Show version", "spring cloud --version"));
    }

    private static class LauncherOptionHandler
    extends OptionHandler {
        private OptionSpec<Void> debugOption;
        private OptionSpec<Void> listOption;
        private OptionSpec<Void> versionOption;

        private LauncherOptionHandler() {
        }

        protected void options() {
            this.debugOption = this.option(Arrays.asList("debug", "d"), "Debug logging for the deployer");
            this.listOption = this.option(Arrays.asList("list", "l"), "List the deployables (don't launch anything)");
            this.versionOption = this.option(Arrays.asList("version", "v"), "Show the version (don't launch anything)");
        }

        protected synchronized ExitStatus run(OptionSet options) throws Exception {
            if (options.has(this.versionOption)) {
                System.out.println("Spring Cloud CLI v" + this.getVersion());
                return ExitStatus.OK;
            }
            try {
                URLClassLoader classLoader = this.populateClassloader(options);
                String name = "org.springframework.cloud.launcher.deployer.DeployerThread";
                Class<?> threadClass = classLoader.loadClass(name);
                Constructor<?> constructor = threadClass.getConstructor(ClassLoader.class, String[].class);
                Thread thread = (Thread)constructor.newInstance(classLoader, this.getArgs(options));
                thread.start();
                thread.join();
            }
            catch (Exception e) {
                log.error((Object)"Error running spring cloud", (Throwable)e);
                return ExitStatus.ERROR;
            }
            return ExitStatus.OK;
        }

        private String[] getArgs(OptionSet options) {
            ArrayList<String> args = new ArrayList<String>();
            ArrayList<String> apps = new ArrayList<String>();
            int sourceArgCount = 0;
            for (Object option : options.nonOptionArguments()) {
                if (!(option instanceof String)) continue;
                ++sourceArgCount;
                if (option.toString().startsWith("--")) {
                    args.add(option.toString());
                    continue;
                }
                apps.add(option.toString());
            }
            if (options.has(this.debugOption)) {
                args.add("--debug=true");
            }
            if (options.has(this.listOption)) {
                args.add("--launcher.list=true");
            } else if (!apps.isEmpty()) {
                args.add("--launcher.deploy=" + StringUtils.collectionToCommaDelimitedString(apps));
            }
            args.addAll(options.nonOptionArguments().subList(sourceArgCount, options.nonOptionArguments().size()));
            return args.toArray(new String[args.size()]);
        }

        private URLClassLoader populateClassloader(OptionSet options) throws MalformedURLException {
            URI[] uris;
            DependencyResolutionContext resolutionContext = new DependencyResolutionContext();
            GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), new CompilerConfiguration());
            List repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
            repositoryConfiguration.add(0, new RepositoryConfiguration("local", new File("repository").toURI(), true));
            if (options.has(this.debugOption)) {
                System.setProperty("groovy.grape.report.downloads", "true");
            }
            AetherGrapeEngine grapeEngine = AetherGrapeEngineFactory.create((GroovyClassLoader)loader, (List)repositoryConfiguration, (DependencyResolutionContext)resolutionContext);
            HashMap<String, String> dependency = new HashMap<String, String>();
            dependency.put("group", "org.springframework.cloud.launcher");
            dependency.put("module", "spring-cloud-launcher-deployer");
            dependency.put("version", this.getVersion());
            for (URI uri : uris = grapeEngine.resolve(null, new Map[]{dependency})) {
                loader.addURL(uri.toURL());
            }
            log.debug((Object)("resolved URIs " + Arrays.asList(loader.getURLs())));
            return loader;
        }

        private String getVersion() {
            Package pkg = LauncherCommand.class.getPackage();
            String version = pkg != null ? pkg.getImplementationVersion() : LauncherCommand.DEFAULT_VERSION;
            return version != null ? version : LauncherCommand.DEFAULT_VERSION;
        }
    }
}

