/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher.appB;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
public class AppTestApplication
implements ApplicationListener<RefreshRemoteApplicationEvent> {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private boolean value = false;

    public static void main(String[] args) {
        SpringApplication.run(AppTestApplication.class, (String[])args);
    }

    @GetMapping(value={"/app"})
    public boolean index() {
        this.LOG.info((Object)("Current value: " + this.value));
        return this.value;
    }

    public void onApplicationEvent(RefreshRemoteApplicationEvent refreshRemoteApplicationEvent) {
        this.LOG.info((Object)("Received remote refresh event from origin: " + refreshRemoteApplicationEvent.getOriginService() + " to destination : " + refreshRemoteApplicationEvent.getDestinationService()));
        this.value = true;
    }
}

