/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.tests.grpc;

import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.TlsServerCredentials;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.gateway.tests.grpc.HelloRequest;
import org.springframework.cloud.gateway.tests.grpc.HelloResponse;
import org.springframework.cloud.gateway.tests.grpc.HelloServiceGrpc;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@SpringBootConfiguration
@EnableAutoConfiguration
public class GRPCApplication {
    public static void main(String[] args) {
        SpringApplication.run(GRPCApplication.class, (String[])args);
    }

    @Component
    static class GRPCServer
    implements ApplicationRunner {
        private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
        private final Environment environment;
        private Server server;

        GRPCServer(Environment environment) {
            this.environment = environment;
        }

        public void run(ApplicationArguments args) throws Exception {
            GRPCServer server = new GRPCServer(this.environment);
            server.start();
        }

        private void start() throws IOException {
            Integer serverPort = (Integer)this.environment.getProperty("local.server.port", Integer.class);
            int grpcPort = serverPort + 1;
            ServerCredentials creds = this.createServerCredentials();
            this.server = Grpc.newServerBuilderForPort((int)grpcPort, (ServerCredentials)creds).addService((BindableService)new HelloService()).build().start();
            log.info("Starting gRPC server in port " + grpcPort);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }));
        }

        private ServerCredentials createServerCredentials() throws IOException {
            File certChain = new ClassPathResource("public.cert").getFile();
            File privateKey = new ClassPathResource("private.key").getFile();
            return TlsServerCredentials.create((File)certChain, (File)privateKey);
        }

        private void stop() throws InterruptedException {
            if (this.server != null) {
                this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
            }
            log.info("gRPC server stopped");
        }

        static class HelloService
        extends HelloServiceGrpc.HelloServiceImplBase {
            HelloService() {
            }

            @Override
            public void hello(HelloRequest request, StreamObserver<HelloResponse> responseObserver) {
                if ("failWithRuntimeException!".equals(request.getFirstName())) {
                    StatusRuntimeException exception = Status.FAILED_PRECONDITION.withDescription("Invalid firstName").asRuntimeException();
                    responseObserver.onError((Throwable)exception);
                    responseObserver.onCompleted();
                    return;
                }
                String greeting = String.format("Hello, %s %s", request.getFirstName(), request.getLastName());
                log.info("Sending response: " + greeting);
                HelloResponse response = HelloResponse.newBuilder().setGreeting(greeting).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
        }
    }
}

