/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.tcp;

import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.common.tcp.EncoderDecoderFactoryBean;
import org.springframework.cloud.fn.common.tcp.TcpConnectionFactoryProperties;
import org.springframework.cloud.fn.consumer.tcp.TcpConsumerProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.config.TcpConnectionFactoryFactoryBean;
import org.springframework.integration.ip.tcp.TcpSendingMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.messaging.Message;

@Configuration
@EnableConfigurationProperties(value={TcpConsumerProperties.class, TcpConnectionFactoryProperties.class})
public class TcpConsumerConfiguration {
    @Autowired
    private TcpConsumerProperties properties;
    @Autowired
    private TcpConnectionFactoryProperties tcpConnectionProperties;
    @Qualifier(value="tcpSinkConnectionFactory")
    @Autowired
    private AbstractConnectionFactory connectionFactory;

    @Bean
    public Consumer<Message<?>> tcpConsumer() {
        return arg_0 -> ((TcpSendingMessageHandlerSmartLifeCycle)this.handler()).handleMessage(arg_0);
    }

    @Bean
    public TcpSendingMessageHandlerSmartLifeCycle handler() {
        TcpSendingMessageHandlerSmartLifeCycle tcpMessageHandler = new TcpSendingMessageHandlerSmartLifeCycle();
        tcpMessageHandler.setConnectionFactory(this.connectionFactory);
        return tcpMessageHandler;
    }

    @Bean
    public TcpConnectionFactoryFactoryBean tcpSinkConnectionFactory(@Qualifier(value="tcpSinkEncoder") AbstractByteArraySerializer encoder, @Qualifier(value="tcpSinkMapper") TcpMessageMapper mapper) throws Exception {
        TcpConnectionFactoryFactoryBean factoryBean = new TcpConnectionFactoryFactoryBean();
        factoryBean.setType("client");
        factoryBean.setHost(this.properties.getHost());
        factoryBean.setPort(this.tcpConnectionProperties.getPort());
        factoryBean.setUsingNio(this.tcpConnectionProperties.isNio());
        factoryBean.setUsingDirectBuffers(this.tcpConnectionProperties.isUseDirectBuffers());
        factoryBean.setLookupHost(this.tcpConnectionProperties.isReverseLookup());
        factoryBean.setSerializer((Serializer)encoder);
        factoryBean.setSoTimeout(this.tcpConnectionProperties.getSocketTimeout());
        factoryBean.setMapper(mapper);
        factoryBean.setSingleUse(this.properties.isClose());
        return factoryBean;
    }

    @Bean
    public EncoderDecoderFactoryBean tcpSinkEncoder() {
        return new EncoderDecoderFactoryBean(this.properties.getEncoder());
    }

    @Bean
    public TcpMessageMapper tcpSinkMapper() {
        TcpMessageMapper mapper = new TcpMessageMapper();
        mapper.setCharset(this.properties.getCharset());
        return mapper;
    }

    static class TcpSendingMessageHandlerSmartLifeCycle
    extends TcpSendingMessageHandler
    implements SmartLifecycle {
        TcpSendingMessageHandlerSmartLifeCycle() {
        }

        public boolean isAutoStartup() {
            return true;
        }

        public int getPhase() {
            return Integer.MIN_VALUE;
        }
    }
}

