/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ConfigDataLocation
implements OriginProvider {
    public static final String OPTIONAL_PREFIX = "optional:";
    private final boolean optional;
    private final String value;
    private final @Nullable Origin origin;

    private ConfigDataLocation(boolean optional, String value, @Nullable Origin origin) {
        this.value = value;
        this.optional = optional;
        this.origin = origin;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasPrefix(String prefix) {
        return this.value.startsWith(prefix);
    }

    public String getNonPrefixedValue(String prefix) {
        if (this.hasPrefix(prefix)) {
            return this.value.substring(prefix.length());
        }
        return this.value;
    }

    @Override
    public @Nullable Origin getOrigin() {
        return this.origin;
    }

    public ConfigDataLocation[] split() {
        return this.split(";");
    }

    public ConfigDataLocation[] split(String delimiter) {
        String[] values = StringUtils.delimitedListToStringArray((String)this.toString(), (String)delimiter);
        ConfigDataLocation[] result = new ConfigDataLocation[values.length];
        for (int i = 0; i < values.length; ++i) {
            int index = i;
            ConfigDataLocation configDataLocation = ConfigDataLocation.of(values[index]);
            Assert.state((configDataLocation != null ? 1 : 0) != 0, () -> "Unable to parse '%s'".formatted(values[index]));
            result[i] = configDataLocation.withOrigin(this.getOrigin());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigDataLocation other = (ConfigDataLocation)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return !this.optional ? this.value : OPTIONAL_PREFIX + this.value;
    }

    ConfigDataLocation withOrigin(@Nullable Origin origin) {
        return new ConfigDataLocation(this.optional, this.value, origin);
    }

    public static @Nullable ConfigDataLocation of(@Nullable String location) {
        String value;
        boolean optional;
        boolean bl = optional = location != null && location.startsWith(OPTIONAL_PREFIX);
        if (optional) {
            Assert.state((location != null ? 1 : 0) != 0, (String)"'location' can't be null here");
            value = location.substring(OPTIONAL_PREFIX.length());
        } else {
            value = location;
        }
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        return new ConfigDataLocation(optional, value, null);
    }
}

