/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import org.springframework.boot.logging.LoggingSystem;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class AbstractLoggingSystem
extends LoggingSystem {
    private final ClassLoader classLoader;

    public AbstractLoggingSystem(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void beforeInitialize() {
    }

    @Override
    public void initialize(String configLocation, String logFile) {
        if (StringUtils.hasLength((String)configLocation)) {
            configLocation = SystemPropertyUtils.resolvePlaceholders((String)configLocation);
            this.loadConfiguration(configLocation, logFile);
        } else {
            String selfInitializationConfig = this.getSelfInitializationConfig();
            if (selfInitializationConfig == null) {
                this.loadDefaults(logFile);
            } else if (StringUtils.hasLength((String)logFile)) {
                this.loadConfiguration(selfInitializationConfig, logFile);
            }
        }
    }

    protected String getSelfInitializationConfig() {
        for (String location : this.getStandardConfigLocations()) {
            ClassPathResource resource = new ClassPathResource(location, this.classLoader);
            if (!resource.exists()) continue;
            return "classpath:" + location;
        }
        return null;
    }

    protected abstract String[] getStandardConfigLocations();

    protected abstract void loadDefaults(String var1);

    protected abstract void loadConfiguration(String var1, String var2);

    protected final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected final String getPackagedConfigFile(String fileName) {
        String defaultPath = ClassUtils.getPackageName(this.getClass());
        defaultPath = defaultPath.replace(".", "/");
        defaultPath = defaultPath + "/" + fileName;
        defaultPath = "classpath:" + defaultPath;
        return defaultPath;
    }
}

