/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import javax.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletContextInitializerConfiguration
extends AbstractConfiguration {
    private final ContextHandler contextHandler;
    private final ServletContextInitializer[] initializers;

    public ServletContextInitializerConfiguration(ContextHandler contextHandler, ServletContextInitializer ... initializers) {
        Assert.notNull((Object)contextHandler, (String)"Jetty ContextHandler must not be null");
        Assert.notNull((Object)initializers, (String)"Initializers must not be null");
        this.contextHandler = contextHandler;
        this.initializers = initializers;
    }

    public void configure(WebAppContext context) throws Exception {
        context.addBean((Object)new InitializerListener(), true);
    }

    private class InitializerListener
    extends AbstractLifeCycle {
        private InitializerListener() {
        }

        protected void doStart() throws Exception {
            ContextHandler.Context servletContext = ServletContextInitializerConfiguration.this.contextHandler.getServletContext();
            for (ServletContextInitializer initializer : ServletContextInitializerConfiguration.this.initializers) {
                initializer.onStartup((ServletContext)servletContext);
            }
        }
    }
}

