/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletListenerRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class ServletContextInitializerBeans
extends AbstractCollection<ServletContextInitializer> {
    static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";
    private final Set<Object> seen = new HashSet<Object>();
    private final MultiValueMap<Class<?>, ServletContextInitializer> initializers = new LinkedMultiValueMap();
    private List<ServletContextInitializer> sortedList;

    public ServletContextInitializerBeans(ListableBeanFactory beanFactory) {
        this.addServletContextInitializerBeans(beanFactory);
        this.addAdaptableBeans(beanFactory);
        ArrayList sortedInitializers = new ArrayList();
        for (Map.Entry entry : this.initializers.entrySet()) {
            AnnotationAwareOrderComparator.sort((List)((List)entry.getValue()));
            sortedInitializers.addAll((Collection)entry.getValue());
        }
        this.sortedList = Collections.unmodifiableList(sortedInitializers);
    }

    private void addServletContextInitializerBeans(ListableBeanFactory beanFactory) {
        for (Map.Entry<String, ServletContextInitializer> initializerBean : this.getOrderedBeansOfType(beanFactory, ServletContextInitializer.class)) {
            this.addServletContextInitializerBean(initializerBean.getValue());
        }
    }

    private void addServletContextInitializerBean(ServletContextInitializer initializer) {
        if (initializer instanceof ServletRegistrationBean) {
            this.addServletContextInitializerBean(Servlet.class, initializer, ((ServletRegistrationBean)initializer).getServlet());
        } else if (initializer instanceof FilterRegistrationBean) {
            this.addServletContextInitializerBean(Filter.class, initializer, ((FilterRegistrationBean)initializer).getFilter());
        } else if (initializer instanceof ServletListenerRegistrationBean) {
            this.addServletContextInitializerBean(EventListener.class, initializer, ((ServletListenerRegistrationBean)initializer).getListener());
        } else {
            this.addServletContextInitializerBean(ServletContextInitializer.class, initializer, null);
        }
    }

    private void addServletContextInitializerBean(Class<?> type, ServletContextInitializer initializer, Object source) {
        this.initializers.add(type, (Object)initializer);
        if (source != null) {
            this.seen.add(source);
        }
    }

    private void addAdaptableBeans(ListableBeanFactory beanFactory) {
        MultipartConfigElement multipartConfig = this.getMultipartConfig(beanFactory);
        this.addAsRegistrationBean(beanFactory, Servlet.class, new ServletRegistrationBeanAdapter(multipartConfig));
        this.addAsRegistrationBean(beanFactory, Filter.class, new FilterRegistrationBeanAdapter());
        for (Class<?> listenerType : ServletListenerRegistrationBean.getSupportedTypes()) {
            this.addAsRegistrationBean(beanFactory, EventListener.class, listenerType, new ServletListenerRegistrationBeanAdapter());
        }
    }

    private MultipartConfigElement getMultipartConfig(ListableBeanFactory beanFactory) {
        List<Map.Entry<String, MultipartConfigElement>> beans = this.getOrderedBeansOfType(beanFactory, MultipartConfigElement.class);
        return beans.isEmpty() ? null : beans.get(0).getValue();
    }

    private <T> void addAsRegistrationBean(ListableBeanFactory beanFactory, Class<T> type, RegistrationBeanAdapter<T> adapter) {
        this.addAsRegistrationBean(beanFactory, type, type, adapter);
    }

    private <T, B extends T> void addAsRegistrationBean(ListableBeanFactory beanFactory, Class<T> type, Class<B> beanType, RegistrationBeanAdapter<T> adapter) {
        List<Map.Entry<String, B>> beans = this.getOrderedBeansOfType(beanFactory, beanType);
        for (Map.Entry<String, B> bean : beans) {
            if (!this.seen.add(bean.getValue())) continue;
            RegistrationBean registration = adapter.createRegistrationBean(bean.getKey(), bean.getValue(), beans.size());
            registration.setName(bean.getKey());
            registration.setOrder(this.getOrder(bean.getValue()));
            this.initializers.add(type, (Object)registration);
        }
    }

    private int getOrder(Object value) {
        return new AnnotationAwareOrderComparator(){

            public int getOrder(Object obj) {
                return super.getOrder(obj);
            }
        }.getOrder(value);
    }

    private <T> List<Map.Entry<String, T>> getOrderedBeansOfType(ListableBeanFactory beanFactory, Class<T> type) {
        ArrayList<Map.Entry<String, T>> beans = new ArrayList<Map.Entry<String, T>>();
        Comparator comparator = new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                return AnnotationAwareOrderComparator.INSTANCE.compare(o1.getValue(), o2.getValue());
            }
        };
        String[] names = beanFactory.getBeanNamesForType(type, true, false);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String name : names) {
            map.put(name, beanFactory.getBean(name, type));
        }
        beans.addAll(map.entrySet());
        Collections.sort(beans, comparator);
        return beans;
    }

    @Override
    public Iterator<ServletContextInitializer> iterator() {
        return this.sortedList.iterator();
    }

    @Override
    public int size() {
        return this.sortedList.size();
    }

    private static class ServletListenerRegistrationBeanAdapter
    implements RegistrationBeanAdapter<EventListener> {
        private ServletListenerRegistrationBeanAdapter() {
        }

        @Override
        public RegistrationBean createRegistrationBean(String name, EventListener source, int totalNumberOfSourceBeans) {
            return new ServletListenerRegistrationBean<EventListener>(source);
        }
    }

    private static class FilterRegistrationBeanAdapter
    implements RegistrationBeanAdapter<Filter> {
        private FilterRegistrationBeanAdapter() {
        }

        @Override
        public RegistrationBean createRegistrationBean(String name, Filter source, int totalNumberOfSourceBeans) {
            return new FilterRegistrationBean(source, new ServletRegistrationBean[0]);
        }
    }

    private static class ServletRegistrationBeanAdapter
    implements RegistrationBeanAdapter<Servlet> {
        private final MultipartConfigElement multipartConfig;

        public ServletRegistrationBeanAdapter(MultipartConfigElement multipartConfig) {
            this.multipartConfig = multipartConfig;
        }

        @Override
        public RegistrationBean createRegistrationBean(String name, Servlet source, int totalNumberOfSourceBeans) {
            String url;
            String string = url = totalNumberOfSourceBeans == 1 ? "/" : "/" + name + "/";
            if (name.equals(ServletContextInitializerBeans.DISPATCHER_SERVLET_NAME)) {
                url = "/";
            }
            ServletRegistrationBean bean = new ServletRegistrationBean(source, url);
            bean.setMultipartConfig(this.multipartConfig);
            return bean;
        }
    }

    private static interface RegistrationBeanAdapter<T> {
        public RegistrationBean createRegistrationBean(String var1, T var2, int var3);
    }
}

