/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration", "org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnClass(value={Observation.class, MeterRegistry.class})
@ConditionalOnBean(value={ObservationRegistry.class, MeterRegistry.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public final class WebFluxObservationAutoConfiguration {
    private final ObservationProperties observationProperties;

    WebFluxObservationAutoConfiguration(ObservationProperties observationProperties) {
        this.observationProperties = observationProperties;
    }

    @Bean
    @Order(value=0)
    MeterFilter metricsHttpServerUriTagFilter(MetricsProperties metricsProperties) {
        String name = this.observationProperties.getHttp().getServer().getRequests().getName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> "Reached the maximum number of URI tags for '%s'.".formatted(name));
        return MeterFilter.maximumAllowableTags((String)name, (String)"uri", (int)metricsProperties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerRequestObservationConvention.class})
    DefaultServerRequestObservationConvention defaultServerRequestObservationConvention() {
        return new DefaultServerRequestObservationConvention(this.observationProperties.getHttp().getServer().getRequests().getName());
    }
}

