/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure.actuate.endpoint.web;

import java.util.Collection;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.webflux.actuate.endpoint.web.AdditionalHealthEndpointPathsWebFluxHandlerMapping;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={HealthEndpoint.class, Health.class})
@ConditionalOnBean(value={WebEndpointsSupplier.class, HealthEndpointGroups.class})
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
public class WebFluxHealthEndpointExtensionAutoConfiguration {
    @Bean
    AdditionalHealthEndpointPathsWebFluxHandlerMapping healthEndpointWebFluxHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        ExposableWebEndpoint health = webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().orElse(null);
        return new AdditionalHealthEndpointPathsWebFluxHandlerMapping(new EndpointMapping(""), health, groups.getAllWithAdditionalPath(WebServerNamespace.SERVER));
    }
}

