/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration;
import org.springframework.boot.webflux.autoconfigure.WebFluxProperties;
import org.springframework.boot.webflux.autoconfigure.WebHttpHandlerBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

@AutoConfiguration(after={WebFluxAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherHandler.class, HttpHandler.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnMissingBean(value={HttpHandler.class})
@AutoConfigureOrder(value=-2147483638)
public class HttpHandlerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    public static class AnnotationConfig {
        private final ApplicationContext applicationContext;

        public AnnotationConfig(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Bean
        public HttpHandler httpHandler(ObjectProvider<WebFluxProperties> propsProvider, ObjectProvider<WebHttpHandlerBuilderCustomizer> handlerBuilderCustomizers) {
            WebHttpHandlerBuilder handlerBuilder = WebHttpHandlerBuilder.applicationContext((ApplicationContext)this.applicationContext);
            handlerBuilderCustomizers.orderedStream().forEach(customizer -> customizer.customize(handlerBuilder));
            HttpHandler httpHandler = handlerBuilder.build();
            WebFluxProperties properties = (WebFluxProperties)propsProvider.getIfAvailable();
            if (properties != null && StringUtils.hasText((String)properties.getBasePath())) {
                Map<String, HttpHandler> handlersMap = Collections.singletonMap(properties.getBasePath(), httpHandler);
                return new ContextPathCompositeHandler(handlersMap);
            }
            return httpHandler;
        }
    }
}

