/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class Compression {
    private boolean enabled;
    private String[] mimeTypes = new String[]{"text/html", "text/xml", "text/plain", "text/css", "text/javascript", "application/javascript", "application/json", "application/xml"};
    private String[] additionalMimeTypes = new String[0];
    private String @Nullable [] excludedUserAgents;
    private DataSize minResponseSize = DataSize.ofKilobytes((long)2L);

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String[] getAllMimeTypes() {
        String[] combined = StringUtils.concatenateStringArrays((String[])this.mimeTypes, (String[])this.additionalMimeTypes);
        return combined != null ? combined : this.mimeTypes;
    }

    public String[] getAdditionalMimeTypes() {
        return this.additionalMimeTypes;
    }

    public void setAdditionalMimeTypes(String[] additionalMimeTypes) {
        this.additionalMimeTypes = additionalMimeTypes;
    }

    public String @Nullable [] getExcludedUserAgents() {
        return this.excludedUserAgents;
    }

    public void setExcludedUserAgents(String @Nullable [] excludedUserAgents) {
        this.excludedUserAgents = excludedUserAgents;
    }

    public DataSize getMinResponseSize() {
        return this.minResponseSize;
    }

    public void setMinResponseSize(DataSize minSize) {
        this.minResponseSize = minSize;
    }
}

