/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow.servlet;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.undertow.HttpHandlerFactory;
import org.springframework.boot.undertow.UndertowWebServerFactory;
import org.springframework.boot.undertow.servlet.CompositeResourceManager;
import org.springframework.boot.undertow.servlet.DeploymentManagerHttpHandlerFactory;
import org.springframework.boot.undertow.servlet.FileSessionPersistence;
import org.springframework.boot.undertow.servlet.JarResourceManager;
import org.springframework.boot.undertow.servlet.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.undertow.servlet.UndertowServletWebServer;
import org.springframework.boot.web.error.ErrorPage;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.servlet.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.server.servlet.ContextPath;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.DocumentRoot;
import org.springframework.boot.web.server.servlet.ServletContextInitializers;
import org.springframework.boot.web.server.servlet.ServletWebServerSettings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class UndertowServletWebServerFactory
extends UndertowWebServerFactory
implements ConfigurableServletWebServerFactory,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(UndertowServletWebServerFactory.class);
    private static final Pattern ENCODED_SLASH = Pattern.compile("%2F", 16);
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private final ServletWebServerSettings settings = new ServletWebServerSettings();
    private Set<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new LinkedHashSet<UndertowDeploymentInfoCustomizer>();
    private ResourceLoader resourceLoader;
    private boolean eagerFilterInit = true;
    private boolean preservePathOnForward;

    public UndertowServletWebServerFactory() {
        this.getSettings().getJsp().setRegistered(false);
    }

    public UndertowServletWebServerFactory(int port) {
        super(port);
        this.getSettings().getJsp().setRegistered(false);
    }

    public UndertowServletWebServerFactory(String contextPath, int port) {
        super(port);
        this.getSettings().setContextPath(ContextPath.of((String)contextPath));
        this.getSettings().getJsp().setRegistered(false);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        Assert.notNull(customizers, (String)"'customizers' must not be null");
        this.deploymentInfoCustomizers = new LinkedHashSet<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"'customizers' must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean isEagerFilterInit() {
        return this.eagerFilterInit;
    }

    public void setEagerFilterInit(boolean eagerFilterInit) {
        this.eagerFilterInit = eagerFilterInit;
    }

    public boolean isPreservePathOnForward() {
        return this.preservePathOnForward;
    }

    public void setPreservePathOnForward(boolean preservePathOnForward) {
        this.preservePathOnForward = preservePathOnForward;
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        UndertowServletWebServerFactory undertowServletWebServerFactory = this;
        Supplier<SslBundle> supplier = () -> undertowServletWebServerFactory.getSslBundle();
        undertowServletWebServerFactory = this;
        Undertow.Builder builder = this.createBuilder(this, supplier, () -> undertowServletWebServerFactory.getServerNameSslBundles());
        DeploymentManager manager = this.createManager(initializers);
        return this.getUndertowWebServer(builder, manager, this.getPort());
    }

    private DeploymentManager createManager(ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        this.registerServletContainerInitializerToDriveServletContextInitializers(deployment, initializers);
        deployment.setClassLoader(this.getServletClassLoader());
        deployment.setContextPath(this.getSettings().getContextPath().toString());
        deployment.setDisplayName(this.getSettings().getDisplayName());
        deployment.setDeploymentName("spring-boot");
        if (this.getSettings().isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.getDocumentRootResourceManager());
        deployment.setTempDir(this.createTempDir("undertow"));
        deployment.setEagerFilterInit(this.eagerFilterInit);
        deployment.setPreservePathOnForward(this.preservePathOnForward);
        this.configureMimeMappings(deployment);
        this.configureWebListeners(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.deploymentInfoCustomizers) {
            customizer.customize(deployment);
        }
        if (this.getSettings().getSession().isPersistent()) {
            File dir = this.getSettings().getSession().getSessionStoreDirectory().getValidDirectory(true);
            deployment.setSessionPersistenceManager((SessionPersistenceManager)new FileSessionPersistence(dir));
        }
        this.addLocaleMappings(deployment);
        DeploymentManager manager = Servlets.newContainer().addDeployment(deployment);
        manager.deploy();
        Deployment deployment2 = manager.getDeployment();
        if (deployment2 instanceof DeploymentImpl) {
            DeploymentImpl managerDeployment = (DeploymentImpl)deployment2;
            this.removeSuperfluousMimeMappings(managerDeployment, deployment);
        }
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        Duration timeoutDuration = this.getSettings().getSession().getTimeout();
        int sessionTimeout = this.isZeroOrLess(timeoutDuration) ? -1 : (int)timeoutDuration.getSeconds();
        sessionManager.setDefaultSessionTimeout(sessionTimeout);
        return manager;
    }

    private void configureWebListeners(DeploymentInfo deployment) {
        for (String className : this.getSettings().getWebListenerClassNames()) {
            try {
                deployment.addListener(new ListenerInfo(this.loadWebListenerClass(className)));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Failed to load web listener class '" + className + "'", ex);
            }
        }
    }

    private Class<? extends EventListener> loadWebListenerClass(String className) throws ClassNotFoundException {
        return this.getServletClassLoader().loadClass(className);
    }

    private boolean isZeroOrLess(Duration timeoutDuration) {
        return timeoutDuration == null || timeoutDuration.isZero() || timeoutDuration.isNegative();
    }

    private void addLocaleMappings(DeploymentInfo deployment) {
        this.getSettings().getLocaleCharsetMappings().forEach((locale, charset) -> deployment.addLocaleCharsetMapping(locale.toString(), charset.toString()));
    }

    private void registerServletContainerInitializerToDriveServletContextInitializers(DeploymentInfo deployment, ServletContextInitializer ... initializers) {
        ServletContextInitializers mergedInitializers = ServletContextInitializers.from((ServletWebServerSettings)this.settings, (ServletContextInitializer[])initializers);
        Initializer initializer = new Initializer(mergedInitializers);
        deployment.addServletContainerInitializer(new ServletContainerInitializerInfo(Initializer.class, (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), NO_CLASSES));
    }

    private ClassLoader getServletClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private ResourceManager getDocumentRootResourceManager() {
        Object rootManager;
        DocumentRoot documentRoot = new DocumentRoot(logger);
        documentRoot.setDirectory(this.settings.getDocumentRoot());
        File root = documentRoot.getValidDirectory();
        File docBase = this.getCanonicalDocumentRoot(root);
        List metaInfResourceUrls = this.getSettings().getStaticResourceUrls();
        ArrayList<URL> resourceJarUrls = new ArrayList<URL>();
        ArrayList<Object> managers = new ArrayList<Object>();
        Object object = rootManager = docBase.isDirectory() ? new FileResourceManager(docBase, 0L) : new JarResourceManager(docBase);
        if (root != null) {
            rootManager = new LoaderHidingResourceManager((ResourceManager)rootManager);
        }
        managers.add(rootManager);
        for (URL url : metaInfResourceUrls) {
            if ("file".equals(url.getProtocol())) {
                try {
                    File file = new File(url.toURI());
                    if (file.isFile()) {
                        resourceJarUrls.add(new URL("jar:" + String.valueOf(url) + "!/"));
                        continue;
                    }
                    managers.add(new FileResourceManager(new File(file, "META-INF/resources"), 0L));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            resourceJarUrls.add(url);
        }
        managers.add(new MetaInfResourcesResourceManager(resourceJarUrls));
        return new CompositeResourceManager(managers.toArray(new ResourceManager[0]));
    }

    private File getCanonicalDocumentRoot(File docBase) {
        try {
            File root = docBase != null ? docBase : this.createTempDir("undertow-docbase");
            return root.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get canonical document root", ex);
        }
    }

    private void configureErrorPages(DeploymentInfo deployment) {
        for (ErrorPage errorPage : this.getErrorPages()) {
            deployment.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private io.undertow.servlet.api.ErrorPage getUndertowErrorPage(ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new io.undertow.servlet.api.ErrorPage(errorPage.getPath());
    }

    private void configureMimeMappings(DeploymentInfo deployment) {
        for (MimeMappings.Mapping mimeMapping : this.getSettings().getMimeMappings()) {
            deployment.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    private void removeSuperfluousMimeMappings(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (MimeMapping mapping : deploymentInfo.getMimeMappings()) {
            mappings.put(mapping.getExtension().toLowerCase(Locale.ENGLISH), mapping.getMimeType());
        }
        deployment.setMimeExtensionMappings(mappings);
    }

    protected UndertowServletWebServer getUndertowWebServer(Undertow.Builder builder, DeploymentManager manager, int port) {
        ArrayList<HttpHandlerFactory> initialHandlerFactories = new ArrayList<HttpHandlerFactory>();
        initialHandlerFactories.add(new DeploymentManagerHttpHandlerFactory(manager));
        HttpHandlerFactory cooHandlerFactory = this.getCookieHandlerFactory(manager.getDeployment());
        if (cooHandlerFactory != null) {
            initialHandlerFactories.add(cooHandlerFactory);
        }
        List<HttpHandlerFactory> httpHandlerFactories = this.createHttpHandlerFactories(this, initialHandlerFactories.toArray(new HttpHandlerFactory[0]));
        return new UndertowServletWebServer(builder, httpHandlerFactories, this.getSettings().getContextPath().toString(), port >= 0);
    }

    private HttpHandlerFactory getCookieHandlerFactory(Deployment deployment) {
        Cookie.SameSite sessionSameSite = this.getSettings().getSession().getCookie().getSameSite();
        ArrayList<CookieSameSiteSupplier> suppliers = new ArrayList<CookieSameSiteSupplier>();
        if (sessionSameSite != null) {
            String sessionCookieName = deployment.getServletContext().getSessionCookieConfig().getName();
            suppliers.add(CookieSameSiteSupplier.of((Cookie.SameSite)sessionSameSite).whenHasName(sessionCookieName));
        }
        if (!CollectionUtils.isEmpty((Collection)this.getSettings().getCookieSameSiteSuppliers())) {
            suppliers.addAll(this.getSettings().getCookieSameSiteSuppliers());
        }
        return !suppliers.isEmpty() ? next -> new SuppliedSameSiteCookieHandler(next, suppliers) : null;
    }

    public ServletWebServerSettings getSettings() {
        return this.settings;
    }

    private static class Initializer
    implements ServletContainerInitializer {
        private final ServletContextInitializers initializers;

        Initializer(ServletContextInitializers initializers) {
            this.initializers = initializers;
        }

        public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(servletContext);
            }
        }
    }

    private static final class LoaderHidingResourceManager
    implements ResourceManager {
        private final ResourceManager delegate;

        private LoaderHidingResourceManager(ResourceManager delegate) {
            this.delegate = delegate;
        }

        public Resource getResource(String path) throws IOException {
            if (path.startsWith("/org/springframework/boot")) {
                return null;
            }
            return this.delegate.getResource(path);
        }

        public boolean isResourceChangeListenerSupported() {
            return this.delegate.isResourceChangeListenerSupported();
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            this.delegate.registerResourceChangeListener(listener);
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            this.delegate.removeResourceChangeListener(listener);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class MetaInfResourcesResourceManager
    implements ResourceManager {
        private final List<URL> metaInfResourceJarUrls;

        private MetaInfResourcesResourceManager(List<URL> metaInfResourceJarUrls) {
            this.metaInfResourceJarUrls = metaInfResourceJarUrls;
        }

        public void close() throws IOException {
        }

        public Resource getResource(String path) {
            for (URL url : this.metaInfResourceJarUrls) {
                URLResource resource = this.getMetaInfResource(url, path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
        }

        private URLResource getMetaInfResource(URL resourceJar, String path) {
            try {
                String urlPath = URLEncoder.encode(ENCODED_SLASH.matcher(path).replaceAll("/"), StandardCharsets.UTF_8);
                URL resourceUrl = new URL(String.valueOf(resourceJar) + "META-INF/resources" + urlPath);
                URLResource resource = new URLResource(resourceUrl, path);
                if (resource.getContentLength() < 0L) {
                    return null;
                }
                return resource;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private static class SuppliedSameSiteCookieHandler
    implements HttpHandler {
        private final HttpHandler next;
        private final List<CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieHandler(HttpHandler next, List<CookieSameSiteSupplier> suppliers) {
            this.next = next;
            this.suppliers = suppliers;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.addResponseCommitListener(this::beforeCommit);
            this.next.handleRequest(exchange);
        }

        private void beforeCommit(HttpServerExchange exchange) {
            for (io.undertow.server.handlers.Cookie cookie : exchange.responseCookies()) {
                Cookie.SameSite sameSite = this.getSameSite(this.asServletCookie(cookie));
                if (sameSite == Cookie.SameSite.OMITTED) {
                    cookie.setSameSite(false);
                    continue;
                }
                if (sameSite == null) continue;
                cookie.setSameSiteMode(sameSite.attributeValue());
            }
        }

        private Cookie asServletCookie(io.undertow.server.handlers.Cookie cookie) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            Cookie result = new Cookie(cookie.getName(), cookie.getValue());
            map.from(() -> ((io.undertow.server.handlers.Cookie)cookie).getComment()).to(arg_0 -> ((Cookie)result).setComment(arg_0));
            map.from(() -> ((io.undertow.server.handlers.Cookie)cookie).getDomain()).to(arg_0 -> ((Cookie)result).setDomain(arg_0));
            map.from(() -> ((io.undertow.server.handlers.Cookie)cookie).getMaxAge()).to(arg_0 -> ((Cookie)result).setMaxAge(arg_0));
            map.from(() -> ((io.undertow.server.handlers.Cookie)cookie).getPath()).to(arg_0 -> ((Cookie)result).setPath(arg_0));
            result.setSecure(cookie.isSecure());
            result.setVersion(cookie.getVersion());
            result.setHttpOnly(cookie.isHttpOnly());
            return result;
        }

        private Cookie.SameSite getSameSite(Cookie cookie) {
            for (CookieSameSiteSupplier supplier : this.suppliers) {
                Cookie.SameSite sameSite = supplier.getSameSite(cookie);
                if (sameSite == null) continue;
                return sameSite;
            }
            return null;
        }
    }
}

