/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow.autoconfigure;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="server.undertow")
public class UndertowServerProperties {
    private DataSize maxHttpPostSize = DataSize.ofBytes((long)-1L);
    private DataSize bufferSize;
    private Boolean directBuffers;
    private boolean eagerFilterInit = true;
    private int maxParameters = 1000;
    private int maxHeaders = 200;
    private int maxCookies = 200;
    private Boolean decodeSlash;
    private boolean decodeUrl = true;
    private Charset urlCharset = StandardCharsets.UTF_8;
    private boolean alwaysSetKeepAlive = true;
    private Duration noRequestTimeout;
    private boolean preservePathOnForward = false;
    private final Accesslog accesslog = new Accesslog();
    private final Threads threads = new Threads();
    private final Options options = new Options();

    public DataSize getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    public void setMaxHttpPostSize(DataSize maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
    }

    public DataSize getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(DataSize bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Boolean getDirectBuffers() {
        return this.directBuffers;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public boolean isEagerFilterInit() {
        return this.eagerFilterInit;
    }

    public void setEagerFilterInit(boolean eagerFilterInit) {
        this.eagerFilterInit = eagerFilterInit;
    }

    public int getMaxParameters() {
        return this.maxParameters;
    }

    public void setMaxParameters(Integer maxParameters) {
        this.maxParameters = maxParameters;
    }

    public int getMaxHeaders() {
        return this.maxHeaders;
    }

    public void setMaxHeaders(int maxHeaders) {
        this.maxHeaders = maxHeaders;
    }

    public Integer getMaxCookies() {
        return this.maxCookies;
    }

    public void setMaxCookies(Integer maxCookies) {
        this.maxCookies = maxCookies;
    }

    public Boolean getDecodeSlash() {
        return this.decodeSlash;
    }

    public void setDecodeSlash(Boolean decodeSlash) {
        this.decodeSlash = decodeSlash;
    }

    public boolean isDecodeUrl() {
        return this.decodeUrl;
    }

    public void setDecodeUrl(Boolean decodeUrl) {
        this.decodeUrl = decodeUrl;
    }

    public Charset getUrlCharset() {
        return this.urlCharset;
    }

    public void setUrlCharset(Charset urlCharset) {
        this.urlCharset = urlCharset;
    }

    public boolean isAlwaysSetKeepAlive() {
        return this.alwaysSetKeepAlive;
    }

    public void setAlwaysSetKeepAlive(boolean alwaysSetKeepAlive) {
        this.alwaysSetKeepAlive = alwaysSetKeepAlive;
    }

    public Duration getNoRequestTimeout() {
        return this.noRequestTimeout;
    }

    public void setNoRequestTimeout(Duration noRequestTimeout) {
        this.noRequestTimeout = noRequestTimeout;
    }

    public boolean isPreservePathOnForward() {
        return this.preservePathOnForward;
    }

    public void setPreservePathOnForward(boolean preservePathOnForward) {
        this.preservePathOnForward = preservePathOnForward;
    }

    public Accesslog getAccesslog() {
        return this.accesslog;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public Options getOptions() {
        return this.options;
    }

    public static class Accesslog {
        private boolean enabled = false;
        private String pattern = "common";
        protected String prefix = "access_log.";
        private String suffix = "log";
        private File dir = new File("logs");
        private boolean rotate = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public File getDir() {
            return this.dir;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public boolean isRotate() {
            return this.rotate;
        }

        public void setRotate(boolean rotate) {
            this.rotate = rotate;
        }
    }

    public static class Threads {
        private Integer io;
        private Integer worker;

        public Integer getIo() {
            return this.io;
        }

        public void setIo(Integer io) {
            this.io = io;
        }

        public Integer getWorker() {
            return this.worker;
        }

        public void setWorker(Integer worker) {
            this.worker = worker;
        }
    }

    public static class Options {
        private final Map<String, String> socket = new LinkedHashMap<String, String>();
        private final Map<String, String> server = new LinkedHashMap<String, String>();

        public Map<String, String> getServer() {
            return this.server;
        }

        public Map<String, String> getSocket() {
            return this.socket;
        }
    }
}

