/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.servlet;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.web.servlet.ServletContextInitializer;

class DeferredServletContainerInitializers
implements ServletContainerInitializer,
TomcatEmbeddedContext.DeferredStartupExceptions {
    private static final Log logger = LogFactory.getLog(DeferredServletContainerInitializers.class);
    private final Iterable<ServletContextInitializer> initializers;
    private volatile @Nullable Exception startUpException;

    DeferredServletContainerInitializers(Iterable<ServletContextInitializer> initializers) {
        this.initializers = initializers;
    }

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        block3: {
            try {
                for (ServletContextInitializer initializer : this.initializers) {
                    initializer.onStartup(servletContext);
                }
            }
            catch (Exception ex) {
                this.startUpException = ex;
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)("Error starting Tomcat context. Exception: " + ex.getClass().getName() + ". Message: " + ex.getMessage()));
            }
        }
    }

    @Override
    public void rethrow() throws Exception {
        if (this.startUpException != null) {
            throw this.startUpException;
        }
    }
}

