/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.testcontainers.beans.TestcontainerBeanDefinition;
import org.springframework.boot.testcontainers.service.connection.BeanOrigin;
import org.springframework.boot.testcontainers.service.connection.ConnectionDetailsRegistrar;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.boot.testcontainers.service.connection.SslBundleSource;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.testcontainers.containers.Container;

class ServiceConnectionAutoConfigurationRegistrar
implements ImportBeanDefinitionRegistrar {
    private final BeanFactory beanFactory;

    ServiceConnectionAutoConfigurationRegistrar(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            this.registerBeanDefinitions(listableBeanFactory, registry);
        }
    }

    private void registerBeanDefinitions(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        ConnectionDetailsRegistrar registrar = new ConnectionDetailsRegistrar((ListableBeanFactory)beanFactory, new ConnectionDetailsFactories(null));
        for (String beanName : beanFactory.getBeanNamesForType(Container.class)) {
            MergedAnnotations mergedAnnotations;
            BeanDefinition beanDefinition = this.getBeanDefinition(beanFactory, beanName);
            if (beanDefinition instanceof TestcontainerBeanDefinition) {
                TestcontainerBeanDefinition testcontainerBeanDefinition = (TestcontainerBeanDefinition)beanDefinition;
                mergedAnnotations = testcontainerBeanDefinition.getAnnotations();
            } else {
                mergedAnnotations = null;
            }
            MergedAnnotations annotations = mergedAnnotations;
            for (ServiceConnection serviceConnection : this.getServiceConnections(beanFactory, beanName, annotations)) {
                ContainerConnectionSource source = this.createSource(beanFactory, beanName, beanDefinition, annotations, serviceConnection);
                registrar.registerBeanDefinitions(registry, source);
            }
        }
    }

    private Set<ServiceConnection> getServiceConnections(ConfigurableListableBeanFactory beanFactory, String beanName, @Nullable MergedAnnotations annotations) {
        LinkedHashSet serviceConnections = beanFactory.findAllAnnotationsOnBean(beanName, ServiceConnection.class, false);
        if (annotations != null) {
            serviceConnections = new LinkedHashSet(serviceConnections);
            annotations.stream(ServiceConnection.class).map(MergedAnnotation::synthesize).forEach(serviceConnections::add);
        }
        return serviceConnections;
    }

    private @Nullable BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private <C extends Container<?>> ContainerConnectionSource<C> createSource(ConfigurableListableBeanFactory beanFactory, String beanName, @Nullable BeanDefinition beanDefinition, @Nullable MergedAnnotations annotations, ServiceConnection serviceConnection) {
        String string;
        BeanOrigin origin = new BeanOrigin(beanName, beanDefinition);
        Class containerType = beanFactory.getType(beanName, false);
        if (beanDefinition instanceof TestcontainerBeanDefinition) {
            TestcontainerBeanDefinition testcontainerBeanDefinition = (TestcontainerBeanDefinition)beanDefinition;
            string = testcontainerBeanDefinition.getContainerImageName();
        } else {
            string = null;
        }
        String containerImageName = string;
        Assert.state((containerType != null ? 1 : 0) != 0, (String)"'containerType' must not be null");
        return new ContainerConnectionSource<Container>(beanName, (Origin)origin, containerType, containerImageName, serviceConnection, () -> (Container)beanFactory.getBean(beanName, containerType), SslBundleSource.get((ListableBeanFactory)beanFactory, beanName, annotations), annotations);
    }
}

