/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.core.env.ConfigurableEnvironment;
import org.testcontainers.containers.Container;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TestcontainersStartup {
    SEQUENTIAL{

        @Override
        void start(Collection<? extends Startable> startables) {
            startables.forEach(TestcontainersStartup::start);
        }
    }
    ,
    PARALLEL{

        @Override
        void start(Collection<? extends Startable> startables) {
            SingleStartables singleStartables = new SingleStartables();
            Startables.deepStart(startables.stream().map(singleStartables::getOrCreate)).join();
        }
    };

    public static final String PROPERTY = "spring.testcontainers.beans.startup";

    abstract void start(Collection<? extends Startable> var1);

    static TestcontainersStartup get(@Nullable ConfigurableEnvironment environment) {
        return TestcontainersStartup.get(environment != null ? environment.getProperty(PROPERTY) : null);
    }

    private static TestcontainersStartup get(@Nullable String value) {
        if (value == null) {
            return SEQUENTIAL;
        }
        String canonicalName = TestcontainersStartup.getCanonicalName(value);
        for (TestcontainersStartup candidate : TestcontainersStartup.values()) {
            if (!candidate.name().equalsIgnoreCase(canonicalName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unknown '%s' property value '%s'".formatted(PROPERTY, value));
    }

    private static String getCanonicalName(String name) {
        StringBuilder canonicalName = new StringBuilder(name.length());
        name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
        return canonicalName.toString();
    }

    public static void start(Startable startable) {
        if (!TestcontainersStartup.isRunning(startable)) {
            startable.start();
        }
    }

    private static boolean isRunning(Startable startable) {
        try {
            Container container;
            return startable instanceof Container && (container = (Container)startable).isRunning();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static final class SingleStartables {
        private final Map<Startable, SingleStartable> adapters = new HashMap<Startable, SingleStartable>();

        private SingleStartables() {
        }

        SingleStartable getOrCreate(Startable startable) {
            return this.adapters.computeIfAbsent(startable, this::create);
        }

        private SingleStartable create(Startable startable) {
            return new SingleStartable(this, startable);
        }

        record SingleStartable(SingleStartables singleStartables, Startable startable) implements Startable
        {
            public Set<Startable> getDependencies() {
                Set dependencies = this.startable.getDependencies();
                if (dependencies.isEmpty()) {
                    return dependencies;
                }
                return dependencies.stream().map(this.singleStartables::getOrCreate).collect(Collectors.toCollection(LinkedHashSet::new));
            }

            public void start() {
                TestcontainersStartup.start(this.startable);
            }

            public void stop() {
                this.startable.stop();
            }
        }
    }
}

