/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.boot.testcontainers.service.connection.JksKeyStore;
import org.springframework.boot.testcontainers.service.connection.JksTrustStore;
import org.springframework.boot.testcontainers.service.connection.PemKeyStore;
import org.springframework.boot.testcontainers.service.connection.PemTrustStore;
import org.springframework.boot.testcontainers.service.connection.Ssl;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

record SslBundleSource(Ssl ssl, PemKeyStore pemKeyStore, PemTrustStore pemTrustStore, JksKeyStore jksKeyStore, JksTrustStore jksTrustStore) {
    SslBundleSource {
        boolean hasJks;
        boolean hasPem = pemKeyStore != null || pemTrustStore != null;
        boolean bl = hasJks = jksKeyStore != null || jksTrustStore != null;
        if (hasJks && hasPem) {
            throw new IllegalStateException("PEM and JKS store annotations cannot be used together");
        }
    }

    SslBundle getSslBundle() {
        SslStoreBundle stores = this.stores();
        if (stores == null) {
            return null;
        }
        Ssl ssl = this.ssl != null ? this.ssl : (Ssl)MergedAnnotation.of(Ssl.class).synthesize();
        SslOptions options = SslOptions.of((String[])this.nullIfEmpty(ssl.ciphers()), (String[])this.nullIfEmpty(ssl.enabledProtocols()));
        SslBundleKey key = SslBundleKey.of((String)this.nullIfEmpty(ssl.keyPassword()), (String)this.nullIfEmpty(ssl.keyAlias()));
        String protocol = ssl.protocol();
        return SslBundle.of((SslStoreBundle)stores, (SslBundleKey)key, (SslOptions)options, (String)protocol);
    }

    private SslStoreBundle stores() {
        if (this.pemKeyStore != null || this.pemTrustStore != null) {
            return new PemSslStoreBundle(this.pemKeyStoreDetails(), this.pemTrustStoreDetails());
        }
        if (this.jksKeyStore != null || this.jksTrustStore != null) {
            return new JksSslStoreBundle(this.jksKeyStoreDetails(), this.jksTrustStoreDetails());
        }
        return null;
    }

    private PemSslStoreDetails pemKeyStoreDetails() {
        PemKeyStore store = this.pemKeyStore;
        return store != null ? new PemSslStoreDetails(this.nullIfEmpty(store.type()), this.nullIfEmpty(store.certificate()), this.nullIfEmpty(store.privateKey()), this.nullIfEmpty(store.privateKeyPassword())) : null;
    }

    private PemSslStoreDetails pemTrustStoreDetails() {
        PemTrustStore store = this.pemTrustStore;
        return store != null ? new PemSslStoreDetails(this.nullIfEmpty(store.type()), this.nullIfEmpty(store.certificate()), this.nullIfEmpty(store.privateKey()), this.nullIfEmpty(store.privateKeyPassword())) : null;
    }

    private JksSslStoreDetails jksKeyStoreDetails() {
        JksKeyStore store = this.jksKeyStore;
        return store != null ? new JksSslStoreDetails(this.nullIfEmpty(store.type()), this.nullIfEmpty(store.provider()), this.nullIfEmpty(store.location()), this.nullIfEmpty(store.password())) : null;
    }

    private JksSslStoreDetails jksTrustStoreDetails() {
        JksTrustStore store = this.jksTrustStore;
        return store != null ? new JksSslStoreDetails(this.nullIfEmpty(store.type()), this.nullIfEmpty(store.provider()), this.nullIfEmpty(store.location()), this.nullIfEmpty(store.password())) : null;
    }

    private String nullIfEmpty(String string) {
        if (StringUtils.hasLength((String)string)) {
            return string;
        }
        return null;
    }

    private String[] nullIfEmpty(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array;
    }

    static SslBundleSource get(MergedAnnotations annotations) {
        return SslBundleSource.get(null, null, annotations);
    }

    static SslBundleSource get(ListableBeanFactory beanFactory, String beanName, MergedAnnotations annotations) {
        Ssl ssl = SslBundleSource.getAnnotation(beanFactory, beanName, annotations, Ssl.class);
        PemKeyStore pemKeyStore = SslBundleSource.getAnnotation(beanFactory, beanName, annotations, PemKeyStore.class);
        PemTrustStore pemTrustStore = SslBundleSource.getAnnotation(beanFactory, beanName, annotations, PemTrustStore.class);
        JksKeyStore jksKeyStore = SslBundleSource.getAnnotation(beanFactory, beanName, annotations, JksKeyStore.class);
        JksTrustStore jksTrustStore = SslBundleSource.getAnnotation(beanFactory, beanName, annotations, JksTrustStore.class);
        if (ssl == null && pemKeyStore == null && pemTrustStore == null && jksKeyStore == null && jksTrustStore == null) {
            return null;
        }
        return new SslBundleSource(ssl, pemKeyStore, pemTrustStore, jksKeyStore, jksTrustStore);
    }

    private static <A extends Annotation> A getAnnotation(ListableBeanFactory beanFactory, String beanName, MergedAnnotations annotations, Class<A> annotationType) {
        int size;
        LinkedHashSet found;
        LinkedHashSet linkedHashSet = found = beanFactory != null ? beanFactory.findAllAnnotationsOnBean(beanName, annotationType, false) : Collections.emptySet();
        if (annotations != null) {
            found = new LinkedHashSet(found);
            annotations.stream(annotationType).map(MergedAnnotation::synthesize).forEach(found::add);
        }
        Assert.state(((size = found.size()) <= 1 ? 1 : 0) != 0, () -> "Expected single %s annotation, but found %d".formatted(annotationType.getName(), size));
        return (A)(size > 0 ? (Annotation)found.iterator().next() : null);
    }
}

