/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.Order;
import org.testcontainers.lifecycle.Startable;

@Order(value=0x7FFFFFFF)
class TestcontainersLifecycleBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    TestcontainersLifecycleBeanFactoryPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanNamesForType(Startable.class, false, false)) {
            try {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                String destroyMethodName = beanDefinition.getDestroyMethodName();
                if (destroyMethodName != null && !"(inferred)".equals(destroyMethodName)) continue;
                beanDefinition.setDestroyMethodName("");
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }
}

