/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive.server;

import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.reactive.server.WebTestClientBuilderCustomizer;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

class WebTestClientContextCustomizer
implements ContextCustomizer {
    WebTestClientContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        SpringBootTest springBootTest = (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation((Class)mergedConfig.getTestClass(), SpringBootTest.class);
        if (springBootTest.webEnvironment().isEmbedded()) {
            this.registerWebTestClient(context);
        }
    }

    private void registerWebTestClient(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.registerWebTestClient(registry);
        }
    }

    private void registerWebTestClient(BeanDefinitionRegistry registry) {
        RootBeanDefinition definition = new RootBeanDefinition(WebTestClientRegistrar.class);
        definition.setRole(2);
        registry.registerBeanDefinition(WebTestClientRegistrar.class.getName(), (BeanDefinition)definition);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static class WebTestClientRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        WebTestClientRegistrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), WebTestClient.class, (boolean)false, (boolean)false).length == 0) {
                registry.registerBeanDefinition(WebTestClient.class.getName(), (BeanDefinition)new RootBeanDefinition(WebTestClientFactory.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    public static class WebTestClientFactory
    implements FactoryBean<WebTestClient>,
    ApplicationContextAware {
        private ApplicationContext applicationContext;
        private WebTestClient object;
        private static final String SERVLET_APPLICATION_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
        private static final String REACTIVE_APPLICATION_CONTEXT_CLASS = "org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext";

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return WebTestClient.class;
        }

        public WebTestClient getObject() throws Exception {
            if (this.object == null) {
                this.object = this.createWebTestClient();
            }
            return this.object;
        }

        private WebTestClient createWebTestClient() {
            boolean sslEnabled = this.isSslEnabled(this.applicationContext);
            String port = this.applicationContext.getEnvironment().getProperty("local.server.port", "8080");
            String baseUrl = this.getBaseUrl(sslEnabled, port);
            WebTestClient.Builder builder = WebTestClient.bindToServer();
            this.customizeWebTestClientBuilder(builder, this.applicationContext);
            this.customizeWebTestClientCodecs(builder, this.applicationContext);
            return builder.baseUrl(baseUrl).build();
        }

        private String getBaseUrl(boolean sslEnabled, String port) {
            String basePath = this.deduceBasePath();
            String pathSegment = StringUtils.hasText((String)basePath) ? basePath : "";
            return (sslEnabled ? "https" : "http") + "://localhost:" + port + pathSegment;
        }

        private String deduceBasePath() {
            WebApplicationType webApplicationType = WebTestClientFactory.deduceFromApplicationContext(this.applicationContext.getClass());
            if (webApplicationType == WebApplicationType.REACTIVE) {
                return this.applicationContext.getEnvironment().getProperty("spring.webflux.base-path");
            }
            if (webApplicationType == WebApplicationType.SERVLET) {
                return ((WebApplicationContext)this.applicationContext).getServletContext().getContextPath();
            }
            return null;
        }

        static WebApplicationType deduceFromApplicationContext(Class<?> applicationContextClass) {
            if (WebTestClientFactory.isAssignable(SERVLET_APPLICATION_CONTEXT_CLASS, applicationContextClass)) {
                return WebApplicationType.SERVLET;
            }
            if (WebTestClientFactory.isAssignable(REACTIVE_APPLICATION_CONTEXT_CLASS, applicationContextClass)) {
                return WebApplicationType.REACTIVE;
            }
            return WebApplicationType.NONE;
        }

        private static boolean isAssignable(String target, Class<?> type) {
            try {
                return ClassUtils.resolveClassName((String)target, null).isAssignableFrom(type);
            }
            catch (Throwable ex) {
                return false;
            }
        }

        private boolean isSslEnabled(ApplicationContext context) {
            try {
                AbstractReactiveWebServerFactory webServerFactory = (AbstractReactiveWebServerFactory)context.getBean(AbstractReactiveWebServerFactory.class);
                return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return false;
            }
        }

        private void customizeWebTestClientBuilder(WebTestClient.Builder clientBuilder, ApplicationContext context) {
            for (WebTestClientBuilderCustomizer customizer : context.getBeansOfType(WebTestClientBuilderCustomizer.class).values()) {
                customizer.customize(clientBuilder);
            }
        }

        private void customizeWebTestClientCodecs(WebTestClient.Builder clientBuilder, ApplicationContext context) {
            Collection codecCustomizers = context.getBeansOfType(CodecCustomizer.class).values();
            if (!CollectionUtils.isEmpty(codecCustomizers)) {
                clientBuilder.exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecCustomizers.forEach(codecCustomizer -> codecCustomizer.customize((CodecConfigurer)codecs))).build());
            }
        }
    }
}

