/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.Arrays;
import java.util.Set;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

class SpringBootTestArgs
implements ContextCustomizer {
    private static final String[] NO_ARGS = new String[0];
    private final String[] args;

    SpringBootTestArgs(Class<?> testClass) {
        this.args = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(SpringBootTest.class).getValue("args", String[].class).orElse(NO_ARGS);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
    }

    String[] getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && Arrays.equals(this.args, ((SpringBootTestArgs)obj).args);
    }

    public int hashCode() {
        return Arrays.hashCode(this.args);
    }

    static String[] get(Set<ContextCustomizer> customizers) {
        for (ContextCustomizer customizer : customizers) {
            if (!(customizer instanceof SpringBootTestArgs)) continue;
            SpringBootTestArgs testArgs = (SpringBootTestArgs)customizer;
            return testArgs.args;
        }
        return NO_ARGS;
    }
}

