/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class LocalHostUriTemplateHandler
extends RootUriTemplateHandler {
    private final Environment environment;
    private final String scheme;
    private final String prefix = "server.servlet.";

    public LocalHostUriTemplateHandler(Environment environment) {
        this(environment, "http");
    }

    public LocalHostUriTemplateHandler(Environment environment, String scheme) {
        super((UriTemplateHandler)new DefaultUriBuilderFactory());
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)scheme, (String)"Scheme must not be null");
        this.environment = environment;
        this.scheme = scheme;
    }

    public String getRootUri() {
        String port = this.environment.getProperty("local.server.port", "8080");
        String contextPath = this.environment.getProperty(this.prefix + "context-path", "");
        return this.scheme + "://localhost:" + port + contextPath;
    }
}

