/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.test.autoconfigure.json.ConditionalOnJsonTesters;
import org.springframework.boot.test.autoconfigure.json.JsonTesterFactoryBean;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@AutoConfiguration
@ConditionalOnJsonTesters
public final class JsonTestersAutoConfiguration {
    @Bean
    static JsonMarshalTestersBeanPostProcessor jsonMarshalTestersBeanPostProcessor() {
        return new JsonMarshalTestersBeanPostProcessor();
    }

    @Bean
    @Scope(value="prototype")
    @ImportRuntimeHints(value={BasicJsonTesterRuntimeHints.class})
    FactoryBean<BasicJsonTester> basicJsonTesterFactoryBean() {
        return new JsonTesterFactoryBean(BasicJsonTester.class, null);
    }

    static class JsonMarshalTestersBeanPostProcessor
    implements InstantiationAwareBeanPostProcessor {
        JsonMarshalTestersBeanPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            ReflectionUtils.doWithFields(bean.getClass(), field -> this.processField(bean, field));
            return bean;
        }

        private void processField(Object bean, Field field) {
            if (AbstractJsonMarshalTester.class.isAssignableFrom(field.getType())) {
                this.initializeTester(bean, field, bean.getClass(), ResolvableType.forField((Field)field).getGeneric(new int[0]));
            } else if (BasicJsonTester.class.isAssignableFrom(field.getType())) {
                this.initializeTester(bean, field, bean.getClass());
            }
        }

        private void initializeTester(Object bean, Field field, Object ... args) {
            ReflectionUtils.makeAccessible((Field)field);
            Object tester = ReflectionUtils.getField((Field)field, (Object)bean);
            if (tester != null) {
                ReflectionTestUtils.invokeMethod((Object)tester, (String)"initialize", (Object[])args);
            }
        }
    }

    static class BasicJsonTesterRuntimeHints
    implements RuntimeHintsRegistrar {
        BasicJsonTesterRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            ReflectionHints reflection = hints.reflection();
            reflection.registerType(BasicJsonTester.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            Method method = ReflectionUtils.findMethod(BasicJsonTester.class, (String)"initialize", (Class[])new Class[]{Class.class});
            Assert.state((method != null ? 1 : 0) != 0, (String)"'method' must not be null");
            reflection.registerMethod(method, ExecutableMode.INVOKE);
        }
    }
}

