/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.AotDetector;
import org.springframework.boot.test.autoconfigure.OverrideAutoConfiguration;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class OverrideAutoConfigurationContextCustomizerFactory
implements ContextCustomizerFactory {
    OverrideAutoConfigurationContextCustomizerFactory() {
    }

    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configurationAttributes) {
        if (AotDetector.useGeneratedArtifacts()) {
            return null;
        }
        OverrideAutoConfiguration overrideAutoConfiguration = (OverrideAutoConfiguration)TestContextAnnotationUtils.findMergedAnnotation(testClass, OverrideAutoConfiguration.class);
        boolean enabled = overrideAutoConfiguration == null || overrideAutoConfiguration.enabled();
        return !enabled ? new DisableAutoConfigurationContextCustomizer() : null;
    }

    private static final class DisableAutoConfigurationContextCustomizer
    implements ContextCustomizer {
        private DisableAutoConfigurationContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            TestPropertyValues.of((String[])new String[]{"spring.boot.enableautoconfiguration=false"}).applyTo(context);
        }

        public boolean equals(@Nullable Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

