/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.client;

import com.fasterxml.jackson.databind.Module;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.web.client.RestClientTest;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

class RestClientExcludeFilter
extends AnnotationCustomizableTypeExcludeFilter {
    private static final Set<Class<?>> DEFAULT_INCLUDES;
    private final RestClientTest annotation;

    RestClientExcludeFilter(Class<?> testClass) {
        this.annotation = (RestClientTest)AnnotatedElementUtils.getMergedAnnotation(testClass, RestClientTest.class);
    }

    @Override
    protected boolean defaultInclude(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (super.defaultInclude(metadataReader, metadataReaderFactory)) {
            return true;
        }
        for (Class<?> controller : this.annotation.components()) {
            if (!this.isTypeOrAnnotated(metadataReader, metadataReaderFactory, controller)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasAnnotation() {
        return this.annotation != null;
    }

    @Override
    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        switch (type) {
            case INCLUDE: {
                return this.annotation.includeFilters();
            }
            case EXCLUDE: {
                return this.annotation.excludeFilters();
            }
        }
        throw new IllegalStateException("Unsupported type " + (Object)((Object)type));
    }

    @Override
    protected boolean isUseDefaultFilters() {
        return this.annotation.useDefaultFilters();
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    static {
        LinkedHashSet<Class> includes = new LinkedHashSet<Class>();
        includes.add(Module.class);
        includes.add(JsonComponent.class);
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

