/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.actuate.endpoint;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.session.actuate.endpoint.SessionsDescriptor;
import org.springframework.session.ReactiveFindByIndexNameSessionRepository;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Endpoint(id="sessions")
public class ReactiveSessionsEndpoint {
    private final ReactiveSessionRepository<? extends Session> sessionRepository;
    private final @Nullable ReactiveFindByIndexNameSessionRepository<? extends Session> indexedSessionRepository;

    public ReactiveSessionsEndpoint(ReactiveSessionRepository<? extends Session> sessionRepository, @Nullable ReactiveFindByIndexNameSessionRepository<? extends Session> indexedSessionRepository) {
        Assert.notNull(sessionRepository, (String)"'sessionRepository' must not be null");
        this.sessionRepository = sessionRepository;
        this.indexedSessionRepository = indexedSessionRepository;
    }

    @ReadOperation
    public Mono<SessionsDescriptor> sessionsForUsername(String username) {
        if (this.indexedSessionRepository == null) {
            return Mono.empty();
        }
        return this.indexedSessionRepository.findByPrincipalName(username).map(SessionsDescriptor::new);
    }

    @ReadOperation
    public Mono<SessionsDescriptor.SessionDescriptor> getSession(@Selector String sessionId) {
        return this.sessionRepository.findById(sessionId).map(SessionsDescriptor.SessionDescriptor::new);
    }

    @DeleteOperation
    public Mono<Void> deleteSession(@Selector String sessionId) {
        return this.sessionRepository.deleteById(sessionId);
    }
}

