/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.autoconfigure;

import io.rsocket.RSocket;
import io.rsocket.transport.netty.server.TcpServerTransport;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.rsocket.autoconfigure.RSocketMessageHandlerCustomizer;
import org.springframework.boot.rsocket.autoconfigure.RSocketStrategiesAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.handler.MessagingAdviceBean;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.web.method.ControllerAdviceBean;

@AutoConfiguration(after={RSocketStrategiesAutoConfiguration.class})
@ConditionalOnClass(value={RSocketRequester.class, RSocket.class, TcpServerTransport.class})
public final class RSocketMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    RSocketMessageHandler messageHandler(RSocketStrategies rSocketStrategies, ObjectProvider<RSocketMessageHandlerCustomizer> customizers, ApplicationContext context) {
        RSocketMessageHandler messageHandler = new RSocketMessageHandler();
        messageHandler.setRSocketStrategies(rSocketStrategies);
        customizers.orderedStream().forEach(customizer -> customizer.customize(messageHandler));
        return messageHandler;
    }

    private static final class ControllerAdviceBeanWrapper
    implements MessagingAdviceBean {
        private final ControllerAdviceBean adviceBean;

        private ControllerAdviceBeanWrapper(ControllerAdviceBean adviceBean) {
            this.adviceBean = adviceBean;
        }

        public @Nullable Class<?> getBeanType() {
            return this.adviceBean.getBeanType();
        }

        public Object resolveBean() {
            return this.adviceBean.resolveBean();
        }

        public boolean isApplicableToBeanType(Class<?> beanType) {
            return this.adviceBean.isApplicableToBeanType(beanType);
        }

        public int getOrder() {
            return this.adviceBean.getOrder();
        }
    }

    static final class MessagingAdviceRSocketMessageHandlerCustomizer
    implements RSocketMessageHandlerCustomizer {
        private final ApplicationContext applicationContext;

        MessagingAdviceRSocketMessageHandlerCustomizer(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void customize(RSocketMessageHandler messageHandler) {
            ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)this.applicationContext).forEach(controllerAdviceBean -> messageHandler.registerMessagingAdvice((MessagingAdviceBean)new ControllerAdviceBeanWrapper((ControllerAdviceBean)controllerAdviceBean)));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ControllerAdviceBean.class})
    static class MessagingAdviceConfiguration {
        MessagingAdviceConfiguration() {
        }

        @Bean
        MessagingAdviceRSocketMessageHandlerCustomizer messagingAdviceRSocketMessageHandlerCustomizer(ApplicationContext applicationContext) {
            return new MessagingAdviceRSocketMessageHandlerCustomizer(applicationContext);
        }
    }
}

