/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OracleEnvironment {
    private final String username;
    private final String password;
    private final String database;

    OracleEnvironment(Map<String, String> env, String defaultDatabase) {
        this.username = env.getOrDefault("APP_USER", "system");
        this.password = this.extractPassword(env);
        this.database = env.getOrDefault("ORACLE_DATABASE", defaultDatabase);
    }

    private String extractPassword(Map<String, String> env) {
        if (env.containsKey("APP_USER")) {
            String password = env.get("APP_USER_PASSWORD");
            Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No Oracle app password found");
            return password;
        }
        Assert.state((!env.containsKey("ORACLE_RANDOM_PASSWORD") ? 1 : 0) != 0, (String)"ORACLE_RANDOM_PASSWORD is not supported without APP_USER and APP_USER_PASSWORD");
        String password = env.get("ORACLE_PASSWORD");
        Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No Oracle password found");
        return password;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

