/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Wrapped;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcAutoConfiguration;
import org.springframework.boot.r2dbc.metrics.ConnectionPoolMetrics;

@AutoConfiguration(after={R2dbcAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnClass(value={ConnectionPool.class, MeterRegistry.class})
@ConditionalOnBean(value={ConnectionFactory.class, MeterRegistry.class})
public final class ConnectionPoolMetricsAutoConfiguration {
    @Autowired
    void bindConnectionPoolsToRegistry(ConfigurableListableBeanFactory beanFactory, MeterRegistry registry) {
        SimpleAutowireCandidateResolver.resolveAutowireCandidates((ConfigurableListableBeanFactory)beanFactory, ConnectionFactory.class).forEach((beanName, connectionFactory) -> {
            ConnectionPool pool = this.extractPool(connectionFactory);
            if (pool != null) {
                new ConnectionPoolMetrics(pool, (String)beanName, (Iterable<Tag>)Tags.empty()).bindTo(registry);
            }
        });
    }

    private @Nullable ConnectionPool extractPool(Object candidate) {
        if (candidate instanceof ConnectionPool) {
            ConnectionPool connectionPool = (ConnectionPool)candidate;
            return connectionPool;
        }
        if (candidate instanceof Wrapped) {
            return this.extractPool(((Wrapped)candidate).unwrap());
        }
        return null;
    }
}

