/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.r2dbc")
public class R2dbcProperties {
    private @Nullable String name;
    private boolean generateUniqueName;
    private @Nullable String url;
    private @Nullable String username;
    private @Nullable String password;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Pool pool = new Pool();
    private @Nullable String uniqueName;

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Pool getPool() {
        return this.pool;
    }

    public String determineUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UUID.randomUUID().toString();
        }
        return this.uniqueName;
    }

    public static class Pool {
        private int minIdle = 0;
        private Duration maxIdleTime = Duration.ofMinutes(30L);
        private @Nullable Duration maxLifeTime;
        private @Nullable Duration maxAcquireTime;
        private int acquireRetry = 1;
        private @Nullable Duration maxValidationTime;
        private @Nullable Duration maxCreateConnectionTime;
        private int initialSize = 10;
        private int maxSize = 10;
        private @Nullable String validationQuery;
        private ValidationDepth validationDepth = ValidationDepth.LOCAL;
        private boolean enabled = true;

        public int getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public @Nullable Duration getMaxLifeTime() {
            return this.maxLifeTime;
        }

        public void setMaxLifeTime(@Nullable Duration maxLifeTime) {
            this.maxLifeTime = maxLifeTime;
        }

        public @Nullable Duration getMaxValidationTime() {
            return this.maxValidationTime;
        }

        public void setMaxValidationTime(@Nullable Duration maxValidationTime) {
            this.maxValidationTime = maxValidationTime;
        }

        public @Nullable Duration getMaxAcquireTime() {
            return this.maxAcquireTime;
        }

        public void setMaxAcquireTime(@Nullable Duration maxAcquireTime) {
            this.maxAcquireTime = maxAcquireTime;
        }

        public int getAcquireRetry() {
            return this.acquireRetry;
        }

        public void setAcquireRetry(int acquireRetry) {
            this.acquireRetry = acquireRetry;
        }

        public @Nullable Duration getMaxCreateConnectionTime() {
            return this.maxCreateConnectionTime;
        }

        public void setMaxCreateConnectionTime(@Nullable Duration maxCreateConnectionTime) {
            this.maxCreateConnectionTime = maxCreateConnectionTime;
        }

        public int getInitialSize() {
            return this.initialSize;
        }

        public void setInitialSize(int initialSize) {
            this.initialSize = initialSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public @Nullable String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(@Nullable String validationQuery) {
            this.validationQuery = validationQuery;
        }

        public ValidationDepth getValidationDepth() {
            return this.validationDepth;
        }

        public void setValidationDepth(ValidationDepth validationDepth) {
            this.validationDepth = validationDepth;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

